/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.thread;

import org.apache.avalon.Loggable;
import org.apache.avalon.Poolable;
import org.apache.avalon.util.pool.ThreadSafePool;
import org.apache.avalon.util.thread.ThreadContext;
import org.apache.avalon.util.thread.ThreadPool;
import org.apache.log.Logger;

class WorkerThread
extends Thread
implements Poolable,
Loggable {
    protected static final boolean DEBUG = false;
    protected Logger m_logger;
    protected ThreadPool m_threadPool;
    protected ThreadSafePool m_pool;
    protected Runnable m_work;
    protected boolean m_alive;

    protected WorkerThread(ThreadPool threadPool, ThreadSafePool threadSafePool, String string) {
        super((ThreadGroup)threadPool, string);
        this.m_threadPool = threadPool;
        this.m_pool = threadSafePool;
        this.m_work = null;
        this.m_alive = true;
        this.setDaemon(false);
    }

    public void setLogger(Logger logger) {
        this.m_logger = logger;
    }

    public final synchronized void run() {
        ThreadContext.setCurrentThreadPool(this.m_threadPool);
        while (this.m_alive) {
            this.waitUntilCondition(true);
            try {
                this.m_work.run();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_work = null;
            this.notify();
            if (null != this.m_pool) {
                this.m_pool.put(this);
                continue;
            }
            this.m_alive = false;
        }
    }

    protected synchronized void executeAndWait(Runnable runnable) {
        this.execute(runnable);
        this.waitUntilCondition(false);
    }

    protected synchronized void waitUntilCondition(boolean bl) {
        while (bl == (null == this.m_work)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected synchronized void execute(Runnable runnable) {
        this.m_work = runnable;
        this.notify();
    }

    public void dispose() {
        this.m_alive = false;
    }
}

