/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.thread;

import java.util.Hashtable;
import java.util.Iterator;
import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.Configurable;
import org.apache.avalon.Configuration;
import org.apache.avalon.ConfigurationException;
import org.apache.avalon.util.thread.ThreadManager;
import org.apache.avalon.util.thread.ThreadPool;

public class DefaultThreadManager
extends AbstractLoggable
implements ThreadManager,
Configurable {
    protected final Hashtable m_pools = new Hashtable();

    public void configure(Configuration configuration) throws ConfigurationException {
        Iterator iterator = configuration.getChildren("thread-group");
        while (iterator.hasNext()) {
            Configuration configuration2 = (Configuration)iterator.next();
            String string = configuration2.getChild("name").getValue();
            int n = configuration2.getChild("priority").getValueAsInt(5);
            boolean bl = configuration2.getChild("is-daemon").getValueAsBoolean(false);
            int n2 = configuration2.getChild("min-threads").getValueAsInt(5);
            int n3 = configuration2.getChild("max-threads").getValueAsInt(10);
            int n4 = configuration2.getChild("min-spare-threads").getValueAsInt(n3 - n2);
            try {
                ThreadPool threadPool = new ThreadPool(string, n3);
                threadPool.setDaemon(bl);
                this.setupLogger(threadPool);
                this.m_pools.put(string, threadPool);
            }
            catch (Exception exception) {
                throw new ConfigurationException("Error creating thread pool " + string, exception);
            }
        }
    }

    public ThreadPool getDefaultThreadPool() {
        return this.getThreadPool("default");
    }

    public ThreadPool getThreadPool(String string) {
        ThreadPool threadPool = (ThreadPool)this.m_pools.get(string);
        if (null == threadPool) {
            throw new IllegalArgumentException("No such thread group " + string);
        }
        return threadPool;
    }
}

