/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.test;

import org.apache.avalon.util.BinaryHeap;
import org.apache.testlet.AbstractTestlet;

public final class BinaryHeapTestlet
extends AbstractTestlet {
    protected static final Integer VAL1 = new Integer(1);
    protected static final Integer VAL2 = new Integer(2);
    protected static final Integer VAL3 = new Integer(3);
    protected static final Integer VAL4 = new Integer(4);
    protected static final Integer VAL5 = new Integer(5);
    protected static final Integer VAL6 = new Integer(6);
    protected static final Integer VAL7 = new Integer(7);

    public void testSimpleOrder() {
        BinaryHeap binaryHeap = new BinaryHeap();
        binaryHeap.clear();
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL2);
        binaryHeap.insert(VAL3);
        binaryHeap.insert(VAL4);
        this.assert(VAL1 == binaryHeap.peek());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL2 == binaryHeap.pop());
        this.assert(VAL3 == binaryHeap.pop());
        this.assert(VAL4 == binaryHeap.pop());
    }

    public void testReverseOrder() {
        BinaryHeap binaryHeap = new BinaryHeap();
        binaryHeap.clear();
        binaryHeap.insert(VAL4);
        binaryHeap.insert(VAL3);
        binaryHeap.insert(VAL2);
        binaryHeap.insert(VAL1);
        this.assert(VAL1 == binaryHeap.peek());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL2 == binaryHeap.pop());
        this.assert(VAL3 == binaryHeap.pop());
        this.assert(VAL4 == binaryHeap.pop());
    }

    public void testMixedOrder() {
        BinaryHeap binaryHeap = new BinaryHeap();
        binaryHeap.clear();
        binaryHeap.insert(VAL4);
        binaryHeap.insert(VAL2);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL3);
        this.assert(VAL1 == binaryHeap.peek());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL2 == binaryHeap.pop());
        this.assert(VAL3 == binaryHeap.pop());
        this.assert(VAL4 == binaryHeap.pop());
    }

    public void testDuplicates() {
        BinaryHeap binaryHeap = new BinaryHeap();
        binaryHeap.clear();
        binaryHeap.insert(VAL4);
        binaryHeap.insert(VAL2);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL3);
        this.assert(VAL1 == binaryHeap.peek());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL2 == binaryHeap.pop());
        this.assert(VAL3 == binaryHeap.pop());
        this.assert(VAL4 == binaryHeap.pop());
    }

    public void testMixedInsertPopOrder() {
        BinaryHeap binaryHeap = new BinaryHeap();
        binaryHeap.clear();
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL4);
        binaryHeap.insert(VAL2);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL3);
        this.assert(VAL1 == binaryHeap.peek());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        binaryHeap.insert(VAL4);
        binaryHeap.insert(VAL2);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL3);
        this.assert(VAL1 == binaryHeap.peek());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL2 == binaryHeap.pop());
        this.assert(VAL2 == binaryHeap.pop());
        this.assert(VAL3 == binaryHeap.pop());
        this.assert(VAL3 == binaryHeap.pop());
        this.assert(VAL4 == binaryHeap.pop());
        this.assert(VAL4 == binaryHeap.pop());
    }

    public void testReverseSimpleOrder() {
        BinaryHeap binaryHeap = new BinaryHeap(false);
        binaryHeap.clear();
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL2);
        binaryHeap.insert(VAL3);
        binaryHeap.insert(VAL4);
        this.assert(VAL4 == binaryHeap.pop());
        this.assert(VAL3 == binaryHeap.pop());
        this.assert(VAL2 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.peek());
        this.assert(VAL1 == binaryHeap.pop());
    }

    public void testReverseReverseOrder() {
        BinaryHeap binaryHeap = new BinaryHeap(false);
        binaryHeap.clear();
        binaryHeap.insert(VAL4);
        binaryHeap.insert(VAL3);
        binaryHeap.insert(VAL2);
        binaryHeap.insert(VAL1);
        this.assert(VAL4 == binaryHeap.pop());
        this.assert(VAL3 == binaryHeap.pop());
        this.assert(VAL2 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.peek());
        this.assert(VAL1 == binaryHeap.pop());
    }

    public void testReverseMixedOrder() {
        BinaryHeap binaryHeap = new BinaryHeap(false);
        binaryHeap.clear();
        binaryHeap.insert(VAL4);
        binaryHeap.insert(VAL2);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL3);
        this.assert(VAL4 == binaryHeap.pop());
        this.assert(VAL3 == binaryHeap.pop());
        this.assert(VAL2 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.peek());
        this.assert(VAL1 == binaryHeap.pop());
    }

    public void testReverseDuplicates() {
        BinaryHeap binaryHeap = new BinaryHeap(false);
        binaryHeap.clear();
        binaryHeap.insert(VAL4);
        binaryHeap.insert(VAL3);
        binaryHeap.insert(VAL2);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        this.assert(VAL4 == binaryHeap.pop());
        this.assert(VAL3 == binaryHeap.pop());
        this.assert(VAL2 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.peek());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
    }

    public void testReverseMixedInsertPopOrder() {
        BinaryHeap binaryHeap = new BinaryHeap(false);
        binaryHeap.clear();
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL4);
        binaryHeap.insert(VAL2);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL3);
        this.assert(VAL4 == binaryHeap.pop());
        this.assert(VAL3 == binaryHeap.pop());
        this.assert(VAL2 == binaryHeap.pop());
        binaryHeap.insert(VAL4);
        binaryHeap.insert(VAL2);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL1);
        binaryHeap.insert(VAL3);
        this.assert(VAL4 == binaryHeap.pop());
        this.assert(VAL3 == binaryHeap.pop());
        this.assert(VAL2 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.peek());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.peek());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
        this.assert(VAL1 == binaryHeap.pop());
    }
}

