/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.datasource;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.Disposable;
import org.apache.avalon.Poolable;
import org.apache.avalon.Recyclable;
import org.apache.avalon.util.datasource.JdbcConnection;
import org.apache.avalon.util.pool.Pool;

public class JdbcConnectionPool
extends AbstractLoggable
implements Pool,
Runnable,
Disposable {
    private final String m_dburl;
    private final String m_username;
    private final String m_password;
    private final int m_min;
    private final int m_max;
    private int m_currentCount;
    private List m_active = new ArrayList();
    private List m_ready = new ArrayList();
    private boolean m_monitoring = true;

    public JdbcConnectionPool(String string, String string2, String string3, int n, int n2) {
        this.m_dburl = string;
        this.m_username = string2;
        this.m_password = string3;
        if (n < 0) {
            this.getLogger().warn("Minumum number of connections specified is less than 0, using 0");
            this.m_min = 0;
        } else {
            this.m_min = n;
        }
        if (n2 < n || n2 < 1) {
            this.getLogger().warn("Maximum number of connections specified must be at least 1 and must be greater than the minumum number of connections");
            this.m_max = n > 1 ? n : 1;
        } else {
            this.m_max = n2;
        }
        this.initPool();
    }

    private void initPool() {
        int n = 0;
        while (n < this.m_min) {
            this.m_ready.add(this.createJdbcConnection());
            ++n;
        }
        new Thread(this);
    }

    private JdbcConnection createJdbcConnection() {
        JdbcConnection jdbcConnection = null;
        try {
            if (null == this.m_username) {
                jdbcConnection = new JdbcConnection(DriverManager.getConnection(this.m_dburl), this);
                ++this.m_currentCount;
            } else {
                jdbcConnection = new JdbcConnection(DriverManager.getConnection(this.m_dburl, this.m_username, this.m_password), this);
                ++this.m_currentCount;
            }
        }
        catch (SQLException sQLException) {
            this.getLogger().error("Could not create connection to database", sQLException);
        }
        this.getLogger().debug("JdbcConnection object created");
        return jdbcConnection;
    }

    private void recycle(Recyclable recyclable) {
        this.getLogger().debug("JdbcConnection object recycled");
        recyclable.recycle();
    }

    public Poolable get() throws Exception {
        Poolable poolable = null;
        if (0 == this.m_ready.size()) {
            if (this.m_currentCount < this.m_max) {
                List list = this.m_active;
                synchronized (list) {
                    poolable = this.createJdbcConnection();
                    this.m_active.add(poolable);
                }
            }
            throw new SQLException("There are no more Connections available");
        }
        List list = this.m_active;
        synchronized (list) {
            poolable = (Poolable)this.m_ready.remove(0);
            this.m_active.add(poolable);
        }
        this.getLogger().debug("JdbcConnection '" + this.m_dburl + "' has been requested from pool.");
        return poolable;
    }

    public synchronized void put(Poolable poolable) {
        int n = this.m_active.indexOf(poolable);
        this.m_active.remove(poolable);
        if (this.m_monitoring) {
            this.m_ready.add(poolable);
        }
        this.getLogger().debug("JdbcConnection '" + this.m_dburl + "' has been returned to the pool.");
    }

    public void run() {
        while (this.m_monitoring) {
            if (this.m_ready.size() < this.m_min) {
                this.getLogger().debug("There are not enough Connections for pool: " + this.m_dburl);
                while (this.m_ready.size() < this.m_min && this.m_currentCount < this.m_max) {
                    this.m_ready.add(this.createJdbcConnection());
                }
            } else {
                this.getLogger().debug("Trimming excess fat from pool: " + this.m_dburl);
                while (this.m_ready.size() > this.m_min) {
                    this.recycle((Recyclable)this.m_ready.remove(0));
                }
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                this.getLogger().warn("Caught an InterruptedException", interruptedException);
            }
        }
    }

    public void dispose() {
        this.m_monitoring = false;
        while (!this.m_ready.isEmpty()) {
            this.recycle((Recyclable)this.m_ready.remove(0));
        }
    }
}

