/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.camelot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.avalon.Configuration;
import org.apache.avalon.ConfigurationException;
import org.apache.avalon.DefaultConfigurationBuilder;
import org.apache.avalon.camelot.DeploymentException;
import org.xml.sax.SAXException;

public final class DeployerUtil {
    protected static DefaultConfigurationBuilder c_configurationBuilder;

    private DeployerUtil() {
    }

    protected static DefaultConfigurationBuilder getBuilder() {
        if (null == c_configurationBuilder) {
            c_configurationBuilder = new DefaultConfigurationBuilder();
        }
        return c_configurationBuilder;
    }

    public static final ZipFile getZipFileFor(File file) throws DeploymentException {
        try {
            return new ZipFile(file);
        }
        catch (IOException iOException) {
            throw new DeploymentException("Error opening " + file + " due to " + iOException.getMessage(), iOException);
        }
    }

    public static final Configuration loadConfiguration(ZipFile zipFile, String string) throws DeploymentException {
        return DeployerUtil.buildConfiguration(DeployerUtil.loadResourceStream(zipFile, string));
    }

    public static final Configuration buildConfiguration(InputStream inputStream) throws DeploymentException {
        try {
            return DeployerUtil.getBuilder().build(inputStream);
        }
        catch (SAXException sAXException) {
            throw new DeploymentException("Malformed configuration data", sAXException);
        }
        catch (ConfigurationException configurationException) {
            throw new DeploymentException("Error building configuration", configurationException);
        }
        catch (IOException iOException) {
            throw new DeploymentException("Error reading configuration", iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Manifest loadManifest(ZipFile zipFile) throws DeploymentException {
        InputStream inputStream = DeployerUtil.loadResourceStream(zipFile, "META-INF/MANIFEST.MF");
        try {
            try {
                Manifest manifest = new Manifest(inputStream);
                Object var4_4 = null;
                try {
                    inputStream.close();
                    return manifest;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return manifest;
            }
            catch (IOException iOException) {
                throw new DeploymentException("Error reading manifest", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            inputStream.close();
            throw throwable;
        }
    }

    public static final Properties loadProperties(ZipFile zipFile, String string) throws DeploymentException {
        Properties properties = new Properties();
        try {
            properties.load(DeployerUtil.loadResourceStream(zipFile, string));
        }
        catch (IOException iOException) {
            throw new DeploymentException("Error reading " + string + " from " + zipFile.getName(), iOException);
        }
        return properties;
    }

    public static final InputStream loadResourceStream(ZipFile zipFile, String string) throws DeploymentException {
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (null == zipEntry) {
            throw new DeploymentException("Unable to locate " + string + " in " + zipFile.getName());
        }
        try {
            return zipFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            throw new DeploymentException("Error reading " + string + " from " + zipFile.getName(), iOException);
        }
    }
}

