/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.i18n;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.avalon.util.i18n.XMLResourceBundle;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLResourceBundleFactory {
    protected static Hashtable cache = new Hashtable();
    protected static String directory;

    public static XMLResourceBundle getBundle(String name) throws MissingResourceException {
        return XMLResourceBundleFactory.getBundle(name, Locale.getDefault());
    }

    public static XMLResourceBundle getBundle(String name, Locale loc) throws MissingResourceException {
        return XMLResourceBundleFactory.getBundle(name, loc, false);
    }

    /*
     * Unable to fully structure code
     */
    public static XMLResourceBundle getBundle(String name, Locale loc, boolean cacheAtStartup) throws MissingResourceException {
        parent = null;
        bundleName = XMLResourceBundleFactory.getBundleName(name, loc);
        bundle = XMLResourceBundleFactory.getCachedBundle(bundleName);
        if (bundle != null) {
            return bundle;
        }
        doc = null;
        doc = XMLResourceBundleFactory.loadResourceBundle(bundleName);
        if (doc == null) ** GOTO lbl29
        if (!loc.getLanguage().equals("")) {
            parent = XMLResourceBundleFactory.getParentBundle(name, loc, cacheAtStartup);
        }
        bundle = new XMLResourceBundle(doc, bundleName, parent);
        if (cacheAtStartup) {
            XMLResourceBundleFactory.storeTextElements(bundle, bundle.getResource(), "");
        }
        XMLResourceBundleFactory.updateCache(bundleName, bundle);
        return bundle;
lbl-1000:
        // 1 sources

        {
            bundleName = XMLResourceBundleFactory.getBundleName(name, loc = XMLResourceBundleFactory.getParentLocale(loc));
            bundle = XMLResourceBundleFactory.getCachedBundle(bundleName);
            if (bundle != null) {
                return bundle;
            }
            doc = XMLResourceBundleFactory.loadResourceBundle(bundleName);
            if (doc == null) continue;
            if (!loc.getLanguage().equals("")) {
                parent = XMLResourceBundleFactory.getParentBundle(name, loc, cacheAtStartup);
            }
            bundle = new XMLResourceBundle(doc, bundleName, parent);
            if (cacheAtStartup) {
                XMLResourceBundleFactory.storeTextElements(bundle, bundle.getResource(), "");
            }
            XMLResourceBundleFactory.updateCache(bundleName, bundle);
            return bundle;
lbl29:
            // 2 sources

            ** while (!loc.getLanguage().equals((Object)""))
        }
lbl30:
        // 1 sources

        throw new MissingResourceException("Unable to locate resource: " + bundleName, "XMLResourceBundleFactory", "");
    }

    protected static synchronized XMLResourceBundle getParentBundle(String name, Locale loc) {
        return XMLResourceBundleFactory.getParentBundle(name, loc, false);
    }

    protected static synchronized XMLResourceBundle getParentBundle(String name, Locale loc, boolean cacheAtStartup) {
        loc = XMLResourceBundleFactory.getParentLocale(loc);
        String bundleName = XMLResourceBundleFactory.getBundleName(name, loc);
        Document doc = XMLResourceBundleFactory.loadResourceBundle(bundleName);
        XMLResourceBundle bundle = null;
        if (doc != null) {
            if (!loc.getLanguage().equals("")) {
                bundle = XMLResourceBundleFactory.getParentBundle(name, loc);
            }
            bundle = new XMLResourceBundle(doc, bundleName, bundle);
            if (cacheAtStartup) {
                XMLResourceBundleFactory.storeTextElements(bundle, bundle.getResource(), "");
            }
            XMLResourceBundleFactory.updateCache(bundleName, bundle);
        }
        return bundle;
    }

    protected static Locale getParentLocale(Locale loc) {
        loc = loc.getVariant().equals("") ? (loc.getCountry().equals("") ? new Locale("", "", "") : new Locale(loc.getLanguage(), "", "")) : new Locale(loc.getLanguage(), loc.getCountry(), "");
        return loc;
    }

    protected static synchronized XMLResourceBundle getCachedBundle(String bundleName) {
        return (XMLResourceBundle)cache.get(bundleName);
    }

    protected static synchronized void updateCache(String bundleName, XMLResourceBundle bundle) {
        cache.put(bundleName, bundle);
    }

    protected static String getBundleName(String name, Locale loc) {
        String lang = loc.getLanguage();
        StringBuffer sb = new StringBuffer(XMLResourceBundleFactory.getDirectory());
        if (lang.length() > 0) {
            sb.append("/").append(lang);
        }
        sb.append("/").append(name).append(".xml");
        return sb.toString();
    }

    public static XMLResourceBundle getBundle(String fileName, String localeName) throws MissingResourceException {
        return XMLResourceBundleFactory.getBundle(fileName, new Locale(localeName, localeName));
    }

    public static XMLResourceBundle getBundleFromFilename(String bundleName) throws MissingResourceException {
        return XMLResourceBundleFactory.getBundleFromFilename(bundleName, true);
    }

    public static XMLResourceBundle getBundleFromFilename(String bundleName, boolean cacheAtStartup) throws MissingResourceException {
        Document doc = null;
        doc = XMLResourceBundleFactory.loadResourceBundle(XMLResourceBundleFactory.getDirectory() + "/" + bundleName);
        XMLResourceBundle bundle = XMLResourceBundleFactory.getCachedBundle(bundleName);
        if (bundle != null) {
            return bundle;
        }
        if (doc != null) {
            bundle = new XMLResourceBundle(doc, bundleName, null);
            if (cacheAtStartup) {
                XMLResourceBundleFactory.storeTextElements(bundle, bundle.getResource(), "");
            }
            XMLResourceBundleFactory.updateCache(bundleName, bundle);
            return bundle;
        }
        throw new MissingResourceException("Unable to locate resource: " + bundleName, "XMLResourceBundleFactory", "");
    }

    protected static Document loadResourceBundle(String bundleName) {
        try {
            DOMParser parser = new DOMParser();
            parser.parse(bundleName);
            return parser.getDocument();
        }
        catch (IOException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
    }

    public static void setDirectory(String dir) {
        directory = dir;
    }

    public static String getDirectory() {
        return directory != null ? directory : "";
    }

    private static void storeTextElements(XMLResourceBundle bundle, Node parent, String pathToParent) {
        NodeList children = parent.getChildNodes();
        int childnum = children.getLength();
        int i = 0;
        while (i < childnum) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                String childValue;
                String pathToChild = pathToParent + "/" + child.getNodeName();
                NamedNodeMap attrs = child.getAttributes();
                if (attrs != null) {
                    Node temp = null;
                    String pathToAttr = null;
                    int attrnum = attrs.getLength();
                    int j = 0;
                    while (j < attrnum) {
                        temp = attrs.item(j);
                        pathToAttr = "/@" + temp.getNodeName();
                        bundle.addToCache(pathToChild + pathToAttr, temp.getNodeValue());
                        ++j;
                    }
                }
                if ((childValue = XMLResourceBundleFactory.getTextValue(child)) != null) {
                    bundle.addToCache(pathToChild, childValue);
                } else {
                    XMLResourceBundleFactory.storeTextElements(bundle, child, pathToChild);
                }
            }
            ++i;
        }
    }

    private static String getTextValue(Node element) {
        NodeList list = element.getChildNodes();
        int listsize = list.getLength();
        Node item = null;
        String itemValue = null;
        int i = 0;
        if (i < listsize) {
            item = list.item(i);
            if (item.getNodeType() != 3) {
                return null;
            }
            itemValue = item.getNodeValue();
            if (itemValue == null) {
                return null;
            }
            if ((itemValue = itemValue.trim()).length() == 0) {
                return null;
            }
            return itemValue;
        }
        return null;
    }

    protected XMLResourceBundleFactory() {
    }
}

