/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.File;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.URI;

public class SystemIDResolver {
    public static String getAbsoluteURIFromRelative(String uri) {
        String curdir = "";
        try {
            curdir = System.getProperty("user.dir");
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (null != curdir) {
            String base = curdir.startsWith(File.separator) ? "file://" + curdir : "file:///" + curdir;
            uri = uri != null ? base + System.getProperty("file.separator") + uri : base + System.getProperty("file.separator");
        }
        if (null != uri && uri.indexOf(92) > -1) {
            uri = uri.replace('\\', '/');
        }
        return uri;
    }

    public static String getAbsoluteURI(String url) throws TransformerException {
        if (url.startsWith("..")) {
            url = new File(url).getAbsolutePath();
        }
        if (url.startsWith(File.separator)) {
            url = "file://" + url;
        } else if (url.indexOf(58) < 0) {
            url = SystemIDResolver.getAbsoluteURIFromRelative(url);
        }
        return url;
    }

    public static String getAbsoluteURI(String urlString, String base) throws TransformerException {
        URI uri;
        boolean isAbsouteUrl = false;
        boolean needToResolve = false;
        if (urlString.indexOf(58) > 0) {
            isAbsouteUrl = true;
        } else if (urlString.startsWith(File.separator)) {
            urlString = "file://" + urlString;
            isAbsouteUrl = true;
        }
        if (!(isAbsouteUrl || null != base && base.indexOf(58) >= 0)) {
            base = base != null && base.startsWith(File.separator) ? "file://" + base : SystemIDResolver.getAbsoluteURIFromRelative(base);
        }
        if (null != base && needToResolve) {
            if (base.equals(urlString)) {
                base = "";
            } else {
                urlString = urlString.substring(5);
                isAbsouteUrl = false;
            }
        }
        if (null != base && base.indexOf(92) > -1) {
            base = base.replace('\\', '/');
        }
        if (null != urlString && urlString.indexOf(92) > -1) {
            urlString = urlString.replace('\\', '/');
        }
        try {
            if (null == base || base.length() == 0 || isAbsouteUrl) {
                uri = new URI(urlString);
            } else {
                URI baseURI = new URI(base);
                uri = new URI(baseURI, urlString);
            }
        }
        catch (URI.MalformedURIException mue) {
            throw new TransformerException(mue);
        }
        String uriStr = uri.toString();
        return uriStr;
    }
}

