/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.source;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.excalibur.source.Source;
import org.apache.avalon.excalibur.source.SourceFactory;
import org.apache.avalon.excalibur.source.SourceParameters;
import org.apache.avalon.excalibur.source.SourceResolver;
import org.apache.avalon.excalibur.source.URLSource;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.thread.ThreadSafe;

public class SourceResolverImpl
extends AbstractLoggable
implements ThreadSafe,
Configurable,
Disposable,
Composable,
Contextualizable,
SourceResolver {
    protected ComponentManager manager;
    protected Map sourceFactories;
    protected Context context;
    protected URL baseURL;

    public void configure(Configuration conf) throws ConfigurationException {
        try {
            this.baseURL = new File(System.getProperty("user.dir")).toURL();
        }
        catch (MalformedURLException mue) {
            throw new ConfigurationException("Malformed URL for user.dir");
        }
        try {
            this.getLogger().debug("Getting the SourceFactories");
            HashMap<String, SourceFactory> factories = new HashMap<String, SourceFactory>();
            Configuration[] configs = conf.getChildren("protocol");
            SourceFactory sourceFactory = null;
            String protocol = null;
            int i = 0;
            while (i < configs.length) {
                protocol = configs[i].getAttribute("name");
                if (factories.containsKey(protocol)) {
                    throw new ConfigurationException("SourceFactory defined twice for protocol: " + protocol);
                }
                this.getLogger().debug("\tfor protocol: " + protocol + " " + configs[i].getAttribute("class"));
                sourceFactory = (SourceFactory)Class.forName(configs[i].getAttribute("class")).newInstance();
                this.init(sourceFactory);
                factories.put(protocol, sourceFactory);
                ++i;
            }
            this.sourceFactories = Collections.synchronizedMap(factories);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            this.getLogger().error("Could not get SourceFactories", (Throwable)e);
            throw new ConfigurationException("Could not get parameters because: " + e.getMessage());
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void dispose() {
        Iterator iter = this.sourceFactories.values().iterator();
        while (iter.hasNext()) {
            SourceFactory current = (SourceFactory)iter.next();
            this.deinit(current);
        }
        this.sourceFactories = null;
    }

    public void setBaseURL(URL base) {
        if (SourceResolverImpl.super.getLogger().isDebugEnabled()) {
            SourceResolverImpl.super.getLogger().debug("Changing baseURL to: " + base);
        }
        this.baseURL = base;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public Source resolve(String location) throws MalformedURLException, IOException, ComponentException {
        return this.resolve(this.baseURL, location, null);
    }

    public Source resolve(String location, SourceParameters parameters) throws MalformedURLException, IOException, ComponentException {
        return this.resolve(this.baseURL, location, parameters);
    }

    public Source resolve(URL base, String location) throws MalformedURLException, IOException, ComponentException {
        return this.resolve(base, location, null);
    }

    public Source resolve(URL base, String location, SourceParameters parameters) throws MalformedURLException, IOException, ComponentException {
        String protocol;
        SourceFactory factory;
        String systemID;
        String string;
        SourceResolverImpl.super.getLogger().debug("Resolving '" + location + "' in context '" + base + "'");
        if (location == null) {
            throw new MalformedURLException("Invalid System ID");
        }
        if (base == null) {
            base = this.baseURL;
        }
        if (location.length() == 0) {
            string = base.toExternalForm();
        } else if (location.indexOf(":") > 1) {
            string = location;
        } else if (location.charAt(0) == '/') {
            string = base.getProtocol() + ":" + location;
        } else if (location.length() > 1 && location.charAt(1) == ':') {
            string = base.getProtocol() + ":/" + location;
        } else if (base.getProtocol().equals("file")) {
            File temp = new File(base.toExternalForm().substring("file:".length()), location);
            String path = temp.getAbsolutePath();
            string = path.charAt(0) != File.separator.charAt(0) ? "file:/" + path : "file:" + path;
        } else {
            systemID = new URL(base, location).toExternalForm();
        }
        SourceResolverImpl.super.getLogger().debug("Resolved to systemID '" + systemID + "'");
        Source source = null;
        int protocolPos = systemID.indexOf(58);
        if (protocolPos != -1 && (factory = (SourceFactory)this.sourceFactories.get(protocol = systemID.substring(0, protocolPos))) != null) {
            source = factory.getSource(systemID, parameters);
        }
        if (source == null) {
            try {
                this.getLogger().debug("Making URL from " + systemID);
                source = new URLSource(new URL(systemID), parameters);
            }
            catch (MalformedURLException mue) {
                this.getLogger().debug("Making URL - MalformedURLException in getURL:", (Throwable)mue);
                this.getLogger().debug("Making URL a File (assuming that it is full path):" + systemID);
                source = new URLSource(new File(systemID).toURL(), parameters);
            }
        }
        if (source instanceof Loggable) {
            ((Loggable)source).setLogger(this.getLogger());
        }
        try {
            if (source instanceof Contextualizable) {
                ((Contextualizable)source).contextualize(this.context);
            }
        }
        catch (ContextException ce) {
            throw new ComponentException("ContextException occured during source resolving.", (Throwable)ce);
        }
        if (source instanceof Composable) {
            ((Composable)source).compose(this.manager);
        }
        return source;
    }

    public void release(Source source) {
        if (source == null) {
            return;
        }
        if (source instanceof Recyclable) {
            ((Recyclable)source).recycle();
        }
        if (source instanceof Disposable) {
            ((Disposable)source).dispose();
        }
    }

    private void init(SourceFactory factory) throws ContextException, ComponentException {
        if (factory instanceof Loggable) {
            ((Loggable)factory).setLogger(this.getLogger());
        }
        if (factory instanceof Contextualizable) {
            ((Contextualizable)factory).contextualize(this.context);
        }
        if (factory instanceof Composable) {
            ((Composable)factory).compose(this.manager);
        }
    }

    private void deinit(SourceFactory factory) {
        if (factory instanceof Disposable) {
            ((Disposable)factory).dispose();
        }
    }
}

