/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.extension;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.avalon.excalibur.util.DeweyDecimal;
import org.apache.avalon.excalibur.util.StringUtil;

public final class Extension {
    private String m_extensionName;
    private DeweyDecimal m_specificationVersion;
    private String m_specificationVendor;
    private String m_implementationURL;
    private String m_implementationVendor;
    private String m_implementationVendorId;
    private DeweyDecimal m_implementationVersion;

    public static Extension[] getAvailable(Manifest manifest) {
        Extension extension;
        if (manifest == null) {
            return new Extension[0];
        }
        ArrayList<Extension> results = new ArrayList<Extension>();
        Attributes mainAttributes = manifest.getMainAttributes();
        if (mainAttributes != null && (extension = Extension.getExtension("", mainAttributes)) != null) {
            results.add(extension);
        }
        Map<String, Attributes> entries = manifest.getEntries();
        Iterator<String> keys = entries.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            Attributes attributes = entries.get(key);
            Extension extension2 = Extension.getExtension("", attributes);
            if (extension2 == null) continue;
            results.add(extension2);
        }
        return results.toArray(new Extension[0]);
    }

    public static Extension[] getRequired(Manifest manifest) {
        ArrayList results = new ArrayList();
        Attributes mainAttributes = manifest.getMainAttributes();
        if (mainAttributes != null) {
            Extension.getRequired(mainAttributes, results);
        }
        Map<String, Attributes> entries = manifest.getEntries();
        Iterator<String> keys = entries.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            Attributes attributes = entries.get(key);
            Extension.getRequired(mainAttributes, results);
        }
        return results.toArray(new Extension[0]);
    }

    private static void getRequired(Attributes attributes, ArrayList required) {
        String names = attributes.getValue(Attributes.Name.EXTENSION_LIST);
        if (names == null) {
            return;
        }
        String[] extentions = StringUtil.split(names, " ");
        int i = 0;
        while (i < extentions.length) {
            String prefix = extentions[i] + "-";
            Extension extension = Extension.getExtension(prefix, attributes);
            if (extension != null) {
                required.add(extension);
            }
            ++i;
        }
    }

    private static Extension getExtension(String prefix, Attributes attributes) {
        String name = attributes.getValue(prefix + Attributes.Name.EXTENSION_NAME);
        if (name == null) {
            return null;
        }
        String specVendor = attributes.getValue(prefix + Attributes.Name.SPECIFICATION_VENDOR);
        String specVersion = attributes.getValue(prefix + Attributes.Name.SPECIFICATION_VERSION);
        String impVersion = attributes.getValue(prefix + Attributes.Name.IMPLEMENTATION_VERSION);
        String impVendor = attributes.getValue(prefix + Attributes.Name.IMPLEMENTATION_VENDOR);
        String impVendorId = attributes.getValue(prefix + Attributes.Name.IMPLEMENTATION_VENDOR_ID);
        String impURL = attributes.getValue(prefix + Attributes.Name.IMPLEMENTATION_URL);
        return new Extension(name, specVersion, specVendor, impVersion, impVendor, impVendorId, impURL);
    }

    public String getExtensionName() {
        return this.m_extensionName;
    }

    public String getSpecificationVendor() {
        return this.m_specificationVendor;
    }

    public DeweyDecimal getSpecificationVersion() {
        return this.m_specificationVersion;
    }

    public String getImplementationURL() {
        return this.m_implementationURL;
    }

    public String getImplementationVendor() {
        return this.m_implementationVendor;
    }

    public String getImplementationVendorId() {
        return this.m_implementationVendorId;
    }

    public DeweyDecimal getImplementationVersion() {
        return this.m_implementationVersion;
    }

    public boolean isCompatibleWith(Extension required) {
        if (!this.m_extensionName.equals(required.getExtensionName())) {
            return false;
        }
        DeweyDecimal specificationVersion = required.getSpecificationVersion();
        if (!(specificationVersion == null || this.m_specificationVersion != null && this.isCompatible(this.m_specificationVersion, specificationVersion))) {
            return false;
        }
        String implementationVendorId = required.getImplementationVendorId();
        if (!(implementationVendorId == null || this.m_implementationVendorId != null && this.m_implementationVendorId.equals(implementationVendorId))) {
            return false;
        }
        DeweyDecimal implementationVersion = required.getImplementationVersion();
        return implementationVersion == null || this.m_implementationVersion != null && this.isCompatible(this.m_implementationVersion, implementationVersion);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Extension[");
        sb.append(this.m_extensionName);
        if (this.m_implementationURL != null) {
            sb.append(", implementationURL=");
            sb.append(this.m_implementationURL);
        }
        if (this.m_implementationVendor != null) {
            sb.append(", implementationVendor=");
            sb.append(this.m_implementationVendor);
        }
        if (this.m_implementationVendorId != null) {
            sb.append(", implementationVendorId=");
            sb.append(this.m_implementationVendorId);
        }
        if (this.m_implementationVersion != null) {
            sb.append(", implementationVersion=");
            sb.append(this.m_implementationVersion);
        }
        if (this.m_specificationVendor != null) {
            sb.append(", specificationVendor=");
            sb.append(this.m_specificationVendor);
        }
        if (this.m_specificationVersion != null) {
            sb.append(", specificationVersion=");
            sb.append(this.m_specificationVersion);
        }
        sb.append("]");
        return sb.toString();
    }

    private boolean isCompatible(DeweyDecimal first, DeweyDecimal second) {
        return first.isGreaterThanOrEqual(second);
    }

    public Extension(String extensionName, String specificationVersion, String specificationVendor, String implementationVersion, String implementationVendor, String implementationVendorId, String implementationURL) {
        this.m_extensionName = extensionName;
        this.m_specificationVendor = specificationVendor;
        if (specificationVersion != null) {
            this.m_specificationVersion = new DeweyDecimal(specificationVersion);
        }
        this.m_implementationURL = implementationURL;
        this.m_implementationVendor = implementationVendor;
        this.m_implementationVendorId = implementationVendorId;
        if (implementationVersion != null) {
            this.m_implementationVersion = new DeweyDecimal(implementationVersion);
        }
        if (this.m_extensionName == null) {
            throw new NullPointerException("extensionName property is null");
        }
    }
}

