/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import org.apache.avalon.excalibur.component.ComponentHandler;
import org.apache.avalon.excalibur.component.DefaultComponentFactory;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.log.Logger;

class DefaultComponentHandler
extends ComponentHandler {
    private final DefaultComponentFactory m_factory;
    private boolean m_initialized = false;
    private boolean m_disposed = false;

    public void setLogger(Logger logger) {
        this.m_factory.setLogger(logger);
        super.setLogger(logger);
    }

    public void initialize() {
        if (this.m_initialized) {
            return;
        }
        this.getLogger().debug("ComponentHandler initialized for: " + this.m_factory.getCreatedClass().getName());
        this.m_initialized = true;
    }

    public Component get() throws Exception {
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot get a component from an uninitialized holder.");
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot get a component from a disposed holder");
        }
        return (Component)this.m_factory.newInstance();
    }

    public void put(Component component) {
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot put a component in an uninitialized holder.");
        }
        try {
            this.m_factory.decommission(component);
        }
        catch (Exception e) {
            this.getLogger().warn("Error decommissioning component: " + this.m_factory.getCreatedClass().getName(), (Throwable)e);
        }
    }

    public void dispose() {
        try {
            if (this.m_factory instanceof Disposable) {
                ((Disposable)this.m_factory).dispose();
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Error decommissioning component: " + this.m_factory.getCreatedClass().getName(), (Throwable)e);
        }
        this.m_disposed = true;
    }

    protected DefaultComponentHandler(Class componentClass, Configuration config, ComponentManager manager, Context context, RoleManager roles) throws Exception {
        this.m_factory = new DefaultComponentFactory(componentClass, config, manager, context, roles);
    }
}

