/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.crimson.tree.AttributeNode;
import org.apache.crimson.tree.AttributeNode1;
import org.apache.crimson.tree.CDataNode;
import org.apache.crimson.tree.CommentNode;
import org.apache.crimson.tree.DOMImplementationImpl;
import org.apache.crimson.tree.Doctype;
import org.apache.crimson.tree.DocumentEx;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.ElementEx;
import org.apache.crimson.tree.ElementFactory;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.ElementNode2;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.PINode;
import org.apache.crimson.tree.ParentNode;
import org.apache.crimson.tree.TextNode;
import org.apache.crimson.tree.TreeWalker;
import org.apache.crimson.tree.XmlDocumentBuilder;
import org.apache.crimson.tree.XmlWriteContext;
import org.apache.crimson.util.MessageCatalog;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlDocument
extends ParentNode
implements DocumentEx {
    static String eol;
    static final MessageCatalog catalog;
    private Locale locale = Locale.getDefault();
    private String systemId;
    private ElementFactory factory;
    int mutationCount;
    boolean replaceRootElement;

    public static XmlDocument createXmlDocument(String documentURI, boolean doValidate) throws IOException, SAXException {
        return XmlDocument.createXmlDocument(new InputSource(documentURI), doValidate);
    }

    public static XmlDocument createXmlDocument(String documentURI) throws IOException, SAXException {
        return XmlDocument.createXmlDocument(new InputSource(documentURI), false);
    }

    public static XmlDocument createXmlDocument(InputStream in, boolean doValidate) throws IOException, SAXException {
        return XmlDocument.createXmlDocument(new InputSource(in), doValidate);
    }

    public static XmlDocument createXmlDocument(InputSource in, boolean doValidate) throws IOException, SAXException {
        String prop;
        String defaultReader = "org.apache.crimson.parser.XMLReaderImpl";
        try {
            prop = System.getProperty("org.xml.sax.driver", defaultReader);
        }
        catch (SecurityException se) {
            prop = defaultReader;
        }
        XMLReader xmlReader = XMLReaderFactory.createXMLReader(prop);
        String namespaces = "http://xml.org/sax/features/namespaces";
        xmlReader.setFeature(namespaces, true);
        String nsPrefixes = "http://xml.org/sax/features/namespace-prefixes";
        xmlReader.setFeature(nsPrefixes, true);
        XmlDocumentBuilder builder = new XmlDocumentBuilder();
        xmlReader.setContentHandler(builder);
        String lexHandler = "http://xml.org/sax/properties/lexical-handler";
        xmlReader.setProperty(lexHandler, builder);
        String declHandler = "http://xml.org/sax/properties/declaration-handler";
        xmlReader.setProperty(declHandler, builder);
        xmlReader.setDTDHandler(builder);
        String validation = "http://xml.org/sax/features/validation";
        xmlReader.setFeature(validation, doValidate);
        if (doValidate) {
            xmlReader.setErrorHandler(new DefaultHandler(){

                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
        }
        builder.setDisableNamespaces(true);
        xmlReader.parse(in);
        return builder.getDocument();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    public Locale chooseLocale(String[] languages) {
        Locale l = catalog.chooseLocale(languages);
        if (l != null) {
            this.setLocale(l);
        }
        return l;
    }

    public void write(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF8");
        this.write(writer, "UTF-8");
    }

    public void write(Writer out) throws IOException {
        String encoding = null;
        if (out instanceof OutputStreamWriter) {
            encoding = XmlDocument.java2std(((OutputStreamWriter)out).getEncoding());
        }
        this.write(out, encoding);
    }

    static String java2std(String encodingName) {
        if (encodingName == null) {
            return null;
        }
        if (encodingName.startsWith("ISO8859_")) {
            return "ISO-8859-" + encodingName.substring(8);
        }
        if (encodingName.startsWith("8859_")) {
            return "ISO-8859-" + encodingName.substring(5);
        }
        if ("ASCII7".equalsIgnoreCase(encodingName) || "ASCII".equalsIgnoreCase(encodingName)) {
            return "US-ASCII";
        }
        if ("UTF8".equalsIgnoreCase(encodingName)) {
            return "UTF-8";
        }
        if (encodingName.startsWith("Unicode")) {
            return "UTF-16";
        }
        if ("SJIS".equalsIgnoreCase(encodingName)) {
            return "Shift_JIS";
        }
        if ("JIS".equalsIgnoreCase(encodingName)) {
            return "ISO-2022-JP";
        }
        if ("EUCJIS".equalsIgnoreCase(encodingName)) {
            return "EUC-JP";
        }
        return encodingName;
    }

    public void write(Writer out, String encoding) throws IOException {
        out.write("<?xml version=\"1.0\"");
        if (encoding != null) {
            out.write(" encoding=\"");
            out.write(encoding);
            out.write(34);
        }
        out.write("?>");
        out.write(eol);
        out.write(eol);
        this.writeChildrenXml(this.createWriteContext(out, 0));
        out.write(eol);
        out.flush();
    }

    public XmlWriteContext createWriteContext(Writer out) {
        return new ExtWriteContext(out);
    }

    public XmlWriteContext createWriteContext(Writer out, int level) {
        return new ExtWriteContext(out, level);
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        String encoding = null;
        if (out instanceof OutputStreamWriter) {
            encoding = XmlDocument.java2std(((OutputStreamWriter)out).getEncoding());
        }
        out.write("<?xml version=\"1.0\"");
        if (encoding != null) {
            out.write(" encoding=\"");
            out.write(encoding);
            out.write(34);
        }
        out.write("?>");
        out.write(eol);
        out.write(eol);
        this.writeChildrenXml(context);
    }

    public void writeChildrenXml(XmlWriteContext context) throws IOException {
        int length = this.getLength();
        Writer out = context.getWriter();
        if (length == 0) {
            return;
        }
        int i = 0;
        while (i < length) {
            ((NodeBase)this.item(i)).writeXml(context);
            out.write(eol);
            ++i;
        }
    }

    void checkChildType(int type) throws DOMException {
        switch (type) {
            case 1: 
            case 7: 
            case 8: 
            case 10: {
                return;
            }
        }
        throw new DomEx(3);
    }

    public final void setSystemId(String uri) {
        this.systemId = uri;
    }

    public final String getSystemId() {
        return this.systemId;
    }

    public Node appendChild(Node n) throws DOMException {
        if (n instanceof Element && this.getDocumentElement() != null) {
            throw new DomEx(3);
        }
        if (n instanceof DocumentType && this.getDoctype() != null) {
            throw new DomEx(3);
        }
        return super.appendChild(n);
    }

    public Node insertBefore(Node n, Node refNode) throws DOMException {
        if (!this.replaceRootElement && n instanceof Element && this.getDocumentElement() != null) {
            throw new DomEx(3);
        }
        if (!this.replaceRootElement && n instanceof DocumentType && this.getDoctype() != null) {
            throw new DomEx(3);
        }
        return super.insertBefore(n, refNode);
    }

    /*
     * WARNING - void declaration
     */
    public Node replaceChild(Node newChild, Node refChild) throws DOMException {
        if (newChild instanceof DocumentFragment) {
            Node temp;
            int elemCount = 0;
            int docCount = 0;
            this.replaceRootElement = false;
            ParentNode frag = (ParentNode)newChild;
            int i = 0;
            while ((temp = frag.item(i)) != null) {
                void var6_7;
                if (var6_7 instanceof Element) {
                    ++elemCount;
                } else if (var6_7 instanceof DocumentType) {
                    ++docCount;
                }
                ++i;
            }
            if (elemCount > 1 || docCount > 1) {
                throw new DomEx(3);
            }
            this.replaceRootElement = true;
        }
        return super.replaceChild(newChild, refChild);
    }

    public final short getNodeType() {
        return 9;
    }

    public final DocumentType getDoctype() {
        int i = 0;
        Node n;
        while ((n = this.item(i)) != null) {
            if (n instanceof DocumentType) {
                return (DocumentType)n;
            }
            ++i;
        }
        return null;
    }

    public DocumentType setDoctype(String dtdPublicId, String dtdSystemId, String internalSubset) {
        Doctype retval = (Doctype)this.getDoctype();
        if (retval != null) {
            retval.setPrintInfo(dtdPublicId, dtdSystemId, internalSubset);
        } else {
            retval = new Doctype(dtdPublicId, dtdSystemId, internalSubset);
            retval.setOwnerDocument(this);
            this.insertBefore(retval, this.getFirstChild());
        }
        return retval;
    }

    public Element getDocumentElement() {
        int i = 0;
        Node n;
        while ((n = this.item(i)) != null) {
            if (n instanceof Element) {
                return (Element)n;
            }
            ++i;
        }
        return null;
    }

    public final void setElementFactory(ElementFactory factory) {
        this.factory = factory;
    }

    public final ElementFactory getElementFactory() {
        return this.factory;
    }

    public Element createElement(String tagName) throws DOMException {
        return this.createElementEx(tagName);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        ElementNode2.checkArguments(namespaceURI, qualifiedName);
        ElementNode2 retval = new ElementNode2(namespaceURI, qualifiedName);
        retval.setOwnerDocument(this);
        return retval;
    }

    public final ElementEx createElementEx(String tagName) throws DOMException {
        ElementNode retval;
        if (!XmlNames.isName(tagName)) {
            throw new DomEx(5);
        }
        if (this.factory != null) {
            retval = (ElementNode)this.factory.createElementEx(tagName);
            retval.setTag(tagName);
        } else {
            retval = new ElementNode(tagName);
        }
        retval.setOwnerDocument(this);
        return retval;
    }

    public final ElementEx createElementEx(String uri, String tagName) throws DOMException {
        ElementNode retval;
        if (!XmlNames.isName(tagName)) {
            throw new DomEx(5);
        }
        if (this.factory != null) {
            retval = (ElementNode)this.factory.createElementEx(uri, tagName);
            retval.setTag(tagName);
        } else {
            retval = new ElementNode(tagName);
        }
        retval.setOwnerDocument(this);
        return retval;
    }

    public Text createTextNode(String text) {
        TextNode retval = new TextNode();
        retval.setOwnerDocument(this);
        if (text != null) {
            retval.setText(text.toCharArray());
        }
        return retval;
    }

    public CDATASection createCDATASection(String text) {
        CDataNode retval = new CDataNode();
        if (text != null) {
            retval.setText(text.toCharArray());
        }
        retval.setOwnerDocument(this);
        return retval;
    }

    TextNode newText(char[] buf, int offset, int len) throws SAXException {
        TextNode retval = (TextNode)this.createTextNode(null);
        char[] data = new char[len];
        System.arraycopy(buf, offset, data, 0, len);
        retval.setText(data);
        return retval;
    }

    public ProcessingInstruction createProcessingInstruction(String target, String instructions) throws DOMException {
        if (!XmlNames.isName(target)) {
            throw new DomEx(5);
        }
        PINode retval = new PINode(target, instructions);
        retval.setOwnerDocument(this);
        return retval;
    }

    public Attr createAttribute(String name) throws DOMException {
        if (!XmlNames.isName(name)) {
            throw new DomEx(5);
        }
        AttributeNode1 retval = new AttributeNode1(name, "", true, null);
        retval.setOwnerDocument(this);
        return retval;
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        AttributeNode.checkArguments(namespaceURI, qualifiedName);
        AttributeNode retval = new AttributeNode(namespaceURI, qualifiedName, "", true, null);
        retval.setOwnerDocument(this);
        return retval;
    }

    public Comment createComment(String data) {
        CommentNode retval = new CommentNode(data);
        retval.setOwnerDocument(this);
        return retval;
    }

    public Document getOwnerDoc() {
        return null;
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public DocumentFragment createDocumentFragment() {
        DocFragNode retval = new DocFragNode();
        retval.setOwnerDocument(this);
        return retval;
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        if (!XmlNames.isName(name)) {
            throw new DomEx(5);
        }
        EntityRefNode retval = new EntityRefNode(name);
        retval.setOwnerDocument(this);
        return retval;
    }

    public final String getNodeName() {
        return "#document";
    }

    /*
     * WARNING - void declaration
     */
    public Node cloneNode(boolean deep) {
        XmlDocument retval = new XmlDocument();
        retval.systemId = this.systemId;
        if (deep) {
            Node node;
            int i = 0;
            while ((node = this.item(i)) != null) {
                void var3_4;
                if (!(var3_4 instanceof DocumentType)) {
                    node = var3_4.cloneNode(true);
                    retval.changeNodeOwner(node);
                    retval.appendChild(node);
                }
                ++i;
            }
        }
        return retval;
    }

    public final void changeNodeOwner(Node node) throws DOMException {
        AttributeNode attr;
        Element scope;
        if (node.getOwnerDocument() == this) {
            return;
        }
        if (!(node instanceof NodeBase)) {
            throw new DomEx(4);
        }
        switch (node.getNodeType()) {
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                throw new DomEx(3);
            }
        }
        if (node instanceof AttributeNode && (scope = (attr = (AttributeNode)node).getOwnerElement()) != null && scope.getOwnerDocument() != this) {
            throw new DomEx(3);
        }
        NodeBase n = (NodeBase)node.getParentNode();
        if (n != null) {
            n.removeChild(node);
        }
        TreeWalker walker = new TreeWalker(node);
        n = (NodeBase)walker.getCurrent();
        while (n != null) {
            n.setOwnerDocument(this);
            if (n instanceof Element) {
                NamedNodeMap list = n.getAttributes();
                int length = list.getLength();
                int i = 0;
                while (i < length) {
                    this.changeNodeOwner(list.item(i));
                    ++i;
                }
            }
            n = (NodeBase)walker.getNext();
        }
    }

    public Element getElementById(String elementId) {
        return this.getElementExById(elementId);
    }

    /*
     * WARNING - void declaration
     */
    public ElementEx getElementExById(String id) {
        ElementEx element;
        if (id == null) {
            throw new IllegalArgumentException(this.getMessage("XD-000"));
        }
        TreeWalker w = new TreeWalker(this);
        while ((element = (ElementEx)w.getNextElement(null)) != null) {
            String value;
            void var3_3;
            String idAttr = var3_3.getIdAttributeName();
            if (idAttr == null || !(value = var3_3.getAttribute(idAttr)).equals(id)) continue;
            return var3_3;
        }
        return null;
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        Node node = null;
        switch (importedNode.getNodeType()) {
            case 2: {
                node = importedNode.cloneNode(true);
                break;
            }
            case 11: {
                if (deep) {
                    node = importedNode.cloneNode(true);
                    break;
                }
                node = new DocFragNode();
                break;
            }
            case 9: 
            case 10: {
                throw new DomEx(9);
            }
            case 1: {
                node = ((ElementNode2)importedNode).createCopyForImportNode(deep);
                break;
            }
            case 6: {
                node = importedNode.cloneNode(deep);
                break;
            }
            case 5: {
                node = importedNode.cloneNode(false);
                break;
            }
            default: {
                node = importedNode.cloneNode(false);
            }
        }
        TreeWalker walker = new TreeWalker(node);
        NodeBase n = (NodeBase)walker.getCurrent();
        while (n != null) {
            n.setOwnerDocument(this);
            if (n instanceof Element) {
                NamedNodeMap list = n.getAttributes();
                int length = list.getLength();
                int i = 0;
                while (i < length) {
                    this.changeNodeOwner(list.item(i));
                    ++i;
                }
            }
            n = (NodeBase)walker.getNext();
        }
        return node;
    }

    static {
        String temp;
        try {
            temp = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException e) {
            temp = "\n";
        }
        eol = temp;
        catalog = new Catalog();
    }

    static class Catalog
    extends MessageCatalog {
        static /* synthetic */ Class class$org$apache$crimson$tree$XmlDocument$Catalog;

        Catalog() {
            super(class$org$apache$crimson$tree$XmlDocument$Catalog == null ? (class$org$apache$crimson$tree$XmlDocument$Catalog = Catalog.class$("org.apache.crimson.tree.XmlDocument$Catalog")) : class$org$apache$crimson$tree$XmlDocument$Catalog);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    class ExtWriteContext
    extends XmlWriteContext {
        ExtWriteContext(Writer out) {
            super(out);
        }

        ExtWriteContext(Writer out, int level) {
            super(out, level);
        }

        public boolean isEntityDeclared(String name) {
            if (super.isEntityDeclared(name)) {
                return true;
            }
            DocumentType doctype = XmlDocument.this.getDoctype();
            if (doctype == null) {
                return false;
            }
            return doctype.getEntities().getNamedItem(name) != null;
        }
    }

    static final class EntityRefNode
    extends ParentNode
    implements EntityReference {
        private String entity;

        EntityRefNode(String name) {
            if (name == null) {
                throw new IllegalArgumentException(this.getMessage("XD-002"));
            }
            this.entity = name;
        }

        void checkChildType(int type) throws DOMException {
            switch (type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    return;
                }
            }
            throw new DomEx(3);
        }

        public void writeXml(XmlWriteContext context) throws IOException {
            if (!context.isEntityDeclared(this.entity)) {
                throw new IOException(this.getMessage("XD-003", new Object[]{this.entity}));
            }
            Writer out = context.getWriter();
            out.write(38);
            out.write(this.entity);
            out.write(59);
        }

        public short getNodeType() {
            return 5;
        }

        public String getNodeName() {
            return this.entity;
        }

        /*
         * WARNING - void declaration
         */
        public Node cloneNode(boolean deep) {
            EntityRefNode retval = new EntityRefNode(this.entity);
            retval.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            if (deep) {
                Node node;
                int i = 0;
                while ((node = this.item(i)) != null) {
                    void var3_4;
                    node = var3_4.cloneNode(true);
                    retval.appendChild(node);
                    ++i;
                }
            }
            return retval;
        }
    }

    static final class DocFragNode
    extends ParentNode
    implements DocumentFragment {
        DocFragNode() {
        }

        void checkChildType(int type) throws DOMException {
            switch (type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    return;
                }
            }
            throw new DomEx(3);
        }

        public void writeXml(XmlWriteContext context) throws IOException {
            this.writeChildrenXml(context);
        }

        public Node getParentNode() {
            return null;
        }

        public void setParentNode(Node p) {
            if (p != null) {
                throw new IllegalArgumentException();
            }
        }

        public short getNodeType() {
            return 11;
        }

        public String getNodeName() {
            return "#document-fragment";
        }

        /*
         * WARNING - void declaration
         */
        public Node cloneNode(boolean deep) {
            DocFragNode retval = new DocFragNode();
            retval.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            if (deep) {
                Node node;
                int i = 0;
                while ((node = this.item(i)) != null) {
                    void var3_4;
                    node = var3_4.cloneNode(true);
                    retval.appendChild(node);
                    ++i;
                }
            }
            return retval;
        }
    }
}

