/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xpath.axes.AncestorOrSelfWalker;
import org.apache.xpath.axes.AncestorWalker;
import org.apache.xpath.axes.AttributeIterator;
import org.apache.xpath.axes.AttributeWalker;
import org.apache.xpath.axes.AttributeWalkerOneStep;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.ChildIterator;
import org.apache.xpath.axes.ChildTestIterator;
import org.apache.xpath.axes.ChildWalker;
import org.apache.xpath.axes.ChildWalkerMultiStep;
import org.apache.xpath.axes.ChildWalkerOneStep;
import org.apache.xpath.axes.DescendantIterator;
import org.apache.xpath.axes.DescendantOrSelfWalker;
import org.apache.xpath.axes.DescendantWalker;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.FollowingSiblingWalker;
import org.apache.xpath.axes.FollowingWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.NamespaceWalker;
import org.apache.xpath.axes.ParentWalker;
import org.apache.xpath.axes.PrecedingSiblingWalker;
import org.apache.xpath.axes.PrecedingWalker;
import org.apache.xpath.axes.RootWalker;
import org.apache.xpath.axes.RootWalkerMultiStep;
import org.apache.xpath.axes.SelfWalker;
import org.apache.xpath.axes.SelfWalkerOneStep;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;

public class WalkerFactory {
    static final boolean DEBUG_WALKER_CREATION = false;
    static final boolean DEBUG_ITERATOR_CREATION = false;
    public static final int BITS_COUNT = 255;
    public static final int BITS_RESERVED = 3840;
    public static final int BIT_PREDICATE = 4096;
    public static final int BIT_ANCESTOR = 8192;
    public static final int BIT_ANCESTOR_OR_SELF = 16384;
    public static final int BIT_ATTRIBUTE = 32768;
    public static final int BIT_CHILD = 65536;
    public static final int BIT_DESCENDANT = 131072;
    public static final int BIT_DESCENDANT_OR_SELF = 262144;
    public static final int BIT_FOLLOWING = 524288;
    public static final int BIT_FOLLOWING_SIBLING = 0x100000;
    public static final int BIT_NAMESPACE = 0x200000;
    public static final int BIT_PARENT = 0x400000;
    public static final int BIT_PRECEDING = 0x800000;
    public static final int BIT_PRECEDING_SIBLING = 0x1000000;
    public static final int BIT_SELF = 0x2000000;
    public static final int BIT_FILTER = 0x4000000;
    public static final int BIT_ROOT = 0x8000000;
    public static final int BITMASK_TRAVERSES_OUTSIDE_SUBTREE = 234381312;
    public static final int BIT_BACKWARDS_SELF = 0x10000000;
    public static final int BIT_ANY_DESCENDANT_FROM_ROOT = 0x20000000;
    public static final int BIT_NODETEST_ANY = 0x40000000;
    public static final int BIT_MATCH_PATTERN = Integer.MIN_VALUE;

    private static int analyze(Compiler compiler, int n, int n2) throws TransformerException {
        int n3;
        int[] nArray = compiler.getOpMap();
        int n4 = 0;
        int n5 = 0;
        while ((n3 = nArray[n]) != -1) {
            ++n4;
            boolean bl = WalkerFactory.analyzePredicate(compiler, n, n3);
            if (bl) {
                n5 |= 0x1000;
            }
            switch (n3) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    n5 |= 0x4000000;
                    break;
                }
                case 50: {
                    n5 |= 0x8000000;
                    break;
                }
                case 37: {
                    n5 |= 0x2000;
                    break;
                }
                case 38: {
                    n5 |= 0x4000;
                    break;
                }
                case 39: {
                    n5 |= 0x8000;
                    break;
                }
                case 49: {
                    n5 |= 0x200000;
                    break;
                }
                case 40: {
                    n5 |= 0x10000;
                    break;
                }
                case 41: {
                    n5 |= 0x20000;
                    break;
                }
                case 42: {
                    if (n4 == 2 && n5 == 0x8000000) {
                        n5 |= 0x20000000;
                    }
                    n5 |= 0x40000;
                    break;
                }
                case 43: {
                    n5 |= 0x40000;
                    break;
                }
                case 44: {
                    n5 |= 0x100000;
                    break;
                }
                case 46: {
                    n5 |= 0x800000;
                    break;
                }
                case 47: {
                    n5 |= 0x1000000;
                    break;
                }
                case 45: {
                    n5 |= 0x400000;
                    break;
                }
                case 48: {
                    n5 |= 0x2000000;
                    break;
                }
                case 51: {
                    n5 |= 0x80008000;
                    break;
                }
                case 52: {
                    n5 |= 0x80002000;
                    break;
                }
                case 53: {
                    n5 |= 0x80400000;
                    break;
                }
                default: {
                    throw new RuntimeException("Programmer's assertion: unknown opcode: " + n3);
                }
            }
            if (nArray[n + 3] == 1033) {
                n5 |= 0x40000000;
            }
            if ((n = compiler.getNextStepPos(n)) < 0) break;
        }
        return n5 |= n4 & 0xFF;
    }

    static boolean analyzePredicate(Compiler compiler, int n, int n2) throws TransformerException {
        switch (n2) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                int n3 = compiler.getArgLength(n);
                break;
            }
            default: {
                int n4 = compiler.getArgLengthOfStep(n);
            }
        }
        int n5 = compiler.getFirstPredicateOpPos(n);
        int n6 = compiler.countPredicates(n5);
        return n6 > 0;
    }

    private static AxesWalker createDefaultWalker(Compiler compiler, int n, LocPathIterator locPathIterator, int n2) {
        AxesWalker axesWalker;
        int n3 = compiler.getOp(n);
        boolean bl = false;
        int n4 = n2 & 0xFF;
        boolean bl2 = true;
        switch (n3) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                bl2 = false;
                axesWalker = new FilterExprWalker(locPathIterator);
                bl = true;
                break;
            }
            case 50: {
                if ((n2 & 0xF7DE6F00) == 0) {
                    axesWalker = new RootWalkerMultiStep(locPathIterator);
                    break;
                }
                axesWalker = new RootWalker(locPathIterator);
                break;
            }
            case 37: {
                bl2 = false;
                axesWalker = new AncestorWalker(locPathIterator);
                break;
            }
            case 38: {
                bl2 = false;
                axesWalker = new AncestorOrSelfWalker(locPathIterator);
                break;
            }
            case 39: {
                if (n4 == 1) {
                    axesWalker = new AttributeWalkerOneStep(locPathIterator);
                    break;
                }
                axesWalker = new AttributeWalker(locPathIterator);
                break;
            }
            case 49: {
                axesWalker = new NamespaceWalker(locPathIterator);
                break;
            }
            case 40: {
                if (n4 == 1) {
                    axesWalker = new ChildWalkerOneStep(locPathIterator);
                    break;
                }
                if ((n2 & 0xF7DE6F00) == 0) {
                    axesWalker = new ChildWalkerMultiStep(locPathIterator);
                    break;
                }
                axesWalker = new ChildWalker(locPathIterator);
                break;
            }
            case 41: {
                bl2 = false;
                axesWalker = new DescendantWalker(locPathIterator);
                break;
            }
            case 42: {
                bl2 = false;
                axesWalker = new DescendantOrSelfWalker(locPathIterator);
                break;
            }
            case 43: {
                bl2 = false;
                axesWalker = new FollowingWalker(locPathIterator);
                break;
            }
            case 44: {
                bl2 = false;
                axesWalker = new FollowingSiblingWalker(locPathIterator);
                break;
            }
            case 46: {
                bl2 = false;
                axesWalker = new PrecedingWalker(locPathIterator);
                break;
            }
            case 47: {
                bl2 = false;
                axesWalker = new PrecedingSiblingWalker(locPathIterator);
                break;
            }
            case 45: {
                bl2 = false;
                axesWalker = new ParentWalker(locPathIterator);
                break;
            }
            case 48: {
                if (n4 == 1) {
                    axesWalker = new SelfWalkerOneStep(locPathIterator);
                    break;
                }
                axesWalker = new SelfWalker(locPathIterator);
                break;
            }
            case 51: {
                axesWalker = new AttributeWalker(locPathIterator);
                break;
            }
            case 52: {
                axesWalker = new ChildWalker(locPathIterator);
                break;
            }
            case 53: {
                axesWalker = new ChildWalker(locPathIterator);
                break;
            }
            default: {
                throw new RuntimeException("Programmer's assertion: unknown opcode: " + n3);
            }
        }
        if (bl) {
            axesWalker.initNodeTest(-1);
        } else {
            int n5 = compiler.getWhatToShow(n);
            if ((n5 & 0x43) == 0 || n5 == -1) {
                axesWalker.initNodeTest(n5);
            } else {
                axesWalker.initNodeTest(n5, compiler.getStepNS(n), compiler.getStepLocalName(n));
            }
        }
        return axesWalker;
    }

    static AxesWalker loadOneWalker(LocPathIterator locPathIterator, Compiler compiler, int n) throws TransformerException {
        AxesWalker axesWalker = null;
        int n2 = compiler.getOpMap()[n];
        if (n2 != -1) {
            axesWalker = WalkerFactory.createDefaultWalker(compiler, n2, locPathIterator, 0);
            axesWalker.init(compiler, n, n2);
        }
        return axesWalker;
    }

    static AxesWalker loadWalkers(LocPathIterator locPathIterator, Compiler compiler, int n, int n2) throws TransformerException {
        int n3;
        AxesWalker axesWalker = null;
        AxesWalker axesWalker2 = null;
        int[] nArray = compiler.getOpMap();
        int n4 = WalkerFactory.analyze(compiler, n, n2);
        while ((n3 = nArray[n]) != -1) {
            AxesWalker axesWalker3 = WalkerFactory.createDefaultWalker(compiler, n, locPathIterator, n4);
            axesWalker3.init(compiler, n, n3);
            if (axesWalker == null) {
                axesWalker = axesWalker3;
            } else {
                axesWalker2.setNextWalker(axesWalker3);
                axesWalker3.setPrevWalker(axesWalker2);
            }
            axesWalker2 = axesWalker3;
            n = compiler.getNextStepPos(n);
            if (n < 0) break;
        }
        return axesWalker;
    }

    public static LocPathIterator newLocPathIterator(Compiler compiler, int n) throws TransformerException {
        int n2 = OpMap.getFirstChildPos(n);
        int n3 = WalkerFactory.analyze(compiler, n2, 0);
        if ((n3 & 0x100FF) == 65537) {
            if ((n3 & 0x40000000) == 0x40000000 && (n3 & 0x1000) != 4096) {
                return new ChildIterator(compiler, n, n3);
            }
            return new ChildTestIterator(compiler, n, n3);
        }
        if ((n3 & 0x80FF) == 32769) {
            return new AttributeIterator(compiler, n, n3);
        }
        if ((0x1000 & n3) == 0 && ((n3 & 0x600FF) == 393217 || (n3 & 0x20400FF) == 0x2040002 || (n3 & 0x420500FF) == 1107623939 || (n3 & 0x680500FF) == 1745158147)) {
            return new DescendantIterator(compiler, n, n3);
        }
        return new LocPathIterator(compiler, n, n3, true);
    }
}

