/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.dvsl;

import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.tools.dvsl.DVSLNode;
import org.apache.tools.dvsl.DVSLNodeContext;
import org.apache.tools.dvsl.TemplateHandler;
import org.apache.tools.dvsl.TransformTool;
import org.apache.tools.dvsl.dom4j.Dom4jNodeImpl;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

class Transformer
implements TransformTool {
    private VelocityEngine ve = null;
    private SAXReader saxReader = null;
    private Context baseContext;
    private DVSLNodeContext currentContext;
    private TemplateHandler templateHandler = null;

    public Transformer(VelocityEngine ve, TemplateHandler th, Context context, boolean validate) {
        this.ve = ve;
        this.baseContext = context;
        this.templateHandler = th;
        this.saxReader = new SAXReader(validate);
    }

    private Transformer() {
    }

    long transform(Reader reader, Writer writer) throws Exception {
        Document document = this.saxReader.read(reader);
        return this.transform(document, writer);
    }

    long transform(Document dom4jdoc, Writer writer) throws Exception {
        Dom4jNodeImpl root = new Dom4jNodeImpl(dom4jdoc);
        return this.transform(root, writer);
    }

    protected long transform(DVSLNode root, Writer writer) throws Exception {
        this.currentContext = new DVSLNodeContext(this.baseContext);
        long start = System.currentTimeMillis();
        this.currentContext.put("context", this);
        this.invoke(root, writer);
        long end = System.currentTimeMillis();
        return end - start;
    }

    private void invoke(DVSLNode element, Writer writer) throws Exception {
        String[] arr = new String[]{};
        this.currentContext.pushNode(element);
        this.templateHandler.render(element, (Context)this.currentContext, writer);
        this.currentContext.popNode();
    }

    public Object get(String key) {
        return this.currentContext.get(key);
    }

    public String applyTemplates(DVSLNode node, String xpath) throws Exception {
        List nodeset = node.selectNodes(xpath);
        StringWriter sw = new StringWriter();
        int i = 0;
        while (i < nodeset.size()) {
            DVSLNode n = (DVSLNode)nodeset.get(i);
            this.invoke(n, sw);
            ++i;
        }
        return sw.toString();
    }

    public String applyTemplates(DVSLNode node) throws Exception {
        StringWriter sw = new StringWriter();
        this.invoke(node, sw);
        return sw.toString();
    }

    public String applyTemplates() throws Exception {
        return this.applyTemplates(this.currentContext.peekNode(), "*|@*|text()|comment()|processing-instruction()");
    }

    public String applyTemplates(String path) throws Exception {
        DVSLNode node = this.currentContext.peekNode();
        return this.applyTemplates(node, path);
    }

    public String copy() {
        DVSLNode node = this.currentContext.peekNode();
        return node.copy();
    }
}

