/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.test;

import org.apache.avalon.Context;
import org.apache.avalon.DefaultContext;
import org.apache.avalon.Resolvable;
import org.apache.avalon.util.PropertyException;
import org.apache.avalon.util.PropertyUtil;
import org.apache.testlet.AbstractTestlet;

public final class PropertyUtilTestlet
extends AbstractTestlet {
    protected static final Object OBJ1 = new Object();
    protected static final Object OBJ2 = new Object();
    protected DefaultContext m_context;

    public void initialize() {
        this.m_context = new DefaultContext();
        this.m_context.put("obj1", OBJ1);
        this.m_context.put("obj2", OBJ2);
        this.m_context.put("res1", new ResolveTest(1));
        this.m_context.put("res2", new ResolveTest(2));
        this.m_context.put("res3", new ResolveTest(3));
        this.m_context.put("res4", new ResolveTest(4));
    }

    public void testNoResolve() throws PropertyException {
        Object object = PropertyUtil.resolveProperty("blah", this.m_context, false);
        this.assertEquality(object, "blah");
    }

    public void testObjResolve() throws PropertyException {
        Object object = PropertyUtil.resolveProperty("${obj1}", this.m_context, false);
        this.assertEquality(object, OBJ1);
    }

    public void testObjResolveToText() throws PropertyException {
        Object object = PropertyUtil.resolveProperty("${obj1} ", this.m_context, false);
        this.assertEquality(object, OBJ1 + " ");
    }

    public void testDualObjResolve() throws PropertyException {
        Object object = PropertyUtil.resolveProperty(" ${obj1} ${obj2} ", this.m_context, false);
        this.assertEquality(object, " " + OBJ1 + " " + OBJ2 + " ");
    }

    public void testRecurseObjResolve() throws PropertyException {
        Object object = PropertyUtil.resolveProperty("${res1}", this.m_context, false);
        this.assertEquality(object, new Integer(1));
    }

    public void testRecurseObjResolve2() throws PropertyException {
        Object object = PropertyUtil.resolveProperty("${res2}", this.m_context, false);
        this.assertEquality(object, new Integer(2));
    }

    public void testNullObjResolve() throws PropertyException {
        Object object = PropertyUtil.resolveProperty("${blahaaa}", this.m_context, true);
        this.assertEquality(object, "");
    }

    public void testNullObjResolveForException() throws PropertyException {
        try {
            Object object = PropertyUtil.resolveProperty("${blahaaa}", this.m_context, false);
        }
        catch (PropertyException propertyException) {
            return;
        }
        this.fail("NUll resolve occured without exception");
    }

    protected static final class ResolveTest
    implements Resolvable {
        protected int m_count;
        protected int m_current;

        public ResolveTest(int n) {
            this.m_count = n;
        }

        public Object resolve(Context context) {
            ++this.m_current;
            if (this.m_current >= this.m_count) {
                return new Integer(this.m_count);
            }
            return this;
        }
    }
}

