/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class PatternSet
extends DataType {
    private Vector includeList = new Vector();
    private Vector excludeList = new Vector();

    public void setRefid(Reference r) throws BuildException {
        if (!this.includeList.isEmpty() || !this.excludeList.isEmpty()) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    public NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.includeList);
    }

    public NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.excludeList);
    }

    public void setIncludes(String includes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (includes != null && includes.length() > 0) {
            StringTokenizer tok = new StringTokenizer(includes, ", ", false);
            while (tok.hasMoreTokens()) {
                this.createInclude().setName(tok.nextToken());
            }
        }
    }

    public void setExcludes(String excludes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (excludes != null && excludes.length() > 0) {
            StringTokenizer tok = new StringTokenizer(excludes, ", ", false);
            while (tok.hasMoreTokens()) {
                this.createExclude().setName(tok.nextToken());
            }
        }
    }

    private NameEntry addPatternToList(Vector list) {
        PatternSet patternSet = this;
        if (patternSet == null) {
            throw null;
        }
        NameEntry result = patternSet.new NameEntry();
        list.addElement(result);
        return result;
    }

    public void setIncludesfile(File incl) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (!incl.exists()) {
            throw new BuildException("Includesfile " + incl.getAbsolutePath() + " not found.");
        }
        this.readPatterns(incl, this.includeList);
    }

    public void setExcludesfile(File excl) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (!excl.exists()) {
            throw new BuildException("Excludesfile " + excl.getAbsolutePath() + " not found.");
        }
        this.readPatterns(excl, this.excludeList);
    }

    private void readPatterns(File patternfile, Vector patternlist) throws BuildException {
        try {
            BufferedReader patternReader = new BufferedReader(new FileReader(patternfile));
            String line = patternReader.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    this.addPatternToList(patternlist).setName(line);
                }
                line = patternReader.readLine();
            }
        }
        catch (IOException ioe) {
            String msg = "An error occured while reading from pattern file: " + patternfile;
            throw new BuildException(msg, ioe);
        }
    }

    public void append(PatternSet other, Project p) {
        String[] excl;
        if (this.isReference()) {
            throw new BuildException("Cannot append to a reference");
        }
        String[] incl = other.getIncludePatterns(p);
        if (incl != null) {
            int i = 0;
            while (i < incl.length) {
                this.createInclude().setName(incl[i]);
                ++i;
            }
        }
        if ((excl = other.getExcludePatterns(p)) != null) {
            int i = 0;
            while (i < excl.length) {
                this.createExclude().setName(excl[i]);
                ++i;
            }
        }
    }

    public String[] getIncludePatterns(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getIncludePatterns(p);
        }
        return this.makeArray(this.includeList, p);
    }

    public String[] getExcludePatterns(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getExcludePatterns(p);
        }
        return this.makeArray(this.excludeList, p);
    }

    int countPatterns() {
        return this.includeList.size() + this.excludeList.size();
    }

    private PatternSet getRef(Project p) {
        Object o;
        if (!this.checked) {
            Stack<PatternSet> stk = new Stack<PatternSet>();
            stk.push(this);
            this.dieOnCircularReference(stk, p);
        }
        if (!((o = this.ref.getReferencedObject(p)) instanceof PatternSet)) {
            String msg = this.ref.getRefId() + " doesn't denote a patternset";
            throw new BuildException(msg);
        }
        return (PatternSet)o;
    }

    private String[] makeArray(Vector list, Project p) {
        if (list.size() == 0) {
            return null;
        }
        Vector<String> tmpNames = new Vector<String>();
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            NameEntry ne = (NameEntry)e.nextElement();
            String pattern = ne.evalName(p);
            if (pattern == null || pattern.length() <= 0) continue;
            tmpNames.addElement(pattern);
        }
        Object[] result = new String[tmpNames.size()];
        tmpNames.copyInto(result);
        return result;
    }

    public class NameEntry {
        private String name;
        private String ifCond;
        private String unlessCond;

        public void setName(String name) {
            this.name = name;
        }

        public void setIf(String cond) {
            this.ifCond = cond;
        }

        public void setUnless(String cond) {
            this.unlessCond = cond;
        }

        public String getName() {
            return this.name;
        }

        public String evalName(Project p) {
            return this.valid(p) ? this.name : null;
        }

        private boolean valid(Project p) {
            if (this.ifCond != null && p.getProperty(this.ifCond) == null) {
                return false;
            }
            return this.unlessCond == null || p.getProperty(this.unlessCond) == null;
        }
    }
}

