/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributeListImpl;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectHelperImpl20
extends ProjectHelper {
    private static SAXParserFactory parserFactory = null;
    private XMLReader parser;
    private Project project;
    private File buildFile;
    private File buildFileParent;
    private Locator locator;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(Project project, Object source) throws BuildException {
        if (!(source instanceof File)) {
            throw new BuildException("Only File source supported by default plugin");
        }
        File buildFile = (File)source;
        FileInputStream inputStream = null;
        InputSource inputSource = null;
        this.project = project;
        this.buildFile = new File(buildFile.getAbsolutePath());
        this.buildFileParent = new File(this.buildFile.getParent());
        try {
            try {
                SAXParser saxParser = ProjectHelperImpl20.getParserFactory().newSAXParser();
                this.parser = saxParser.getXMLReader();
                String uri = "file:" + buildFile.getAbsolutePath().replace('\\', '/');
                int index = uri.indexOf(35);
                while (true) {
                    if (index == -1) {
                        inputStream = new FileInputStream(buildFile);
                        inputSource = new InputSource(inputStream);
                        inputSource.setSystemId(uri);
                        project.log("parsing buildfile " + buildFile + " with URI = " + uri, 3);
                        RootHandler hb = new RootHandler();
                        this.parser.setContentHandler(hb);
                        this.parser.setEntityResolver(hb);
                        this.parser.setErrorHandler(hb);
                        this.parser.setDTDHandler(hb);
                        this.parser.parse(inputSource);
                        break;
                    }
                    uri = uri.substring(0, index) + "%23" + uri.substring(index + 1);
                    index = uri.indexOf(35);
                }
            }
            catch (ParserConfigurationException exc) {
                throw new BuildException("Parser has not been configured correctly", (Throwable)exc);
            }
            catch (SAXParseException exc) {
                Location location = new Location(buildFile.toString(), exc.getLineNumber(), exc.getColumnNumber());
                Exception t = exc.getException();
                if (!(t instanceof BuildException)) throw new BuildException(exc.getMessage(), (Throwable)t, location);
                BuildException be = (BuildException)((Object)t);
                if (be.getLocation() != Location.UNKNOWN_LOCATION) throw be;
                be.setLocation(location);
                throw be;
            }
            catch (SAXException exc) {
                Exception t = exc.getException();
                if (!(t instanceof BuildException)) throw new BuildException(exc.getMessage(), (Throwable)t);
                throw (BuildException)((Object)t);
            }
            catch (FileNotFoundException exc) {
                throw new BuildException((Throwable)exc);
            }
            catch (IOException exc) {
                throw new BuildException("Error reading project file", (Throwable)exc);
            }
            Object var12_17 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        inputStream.close();
        return;
    }

    private static SAXParserFactory getParserFactory() {
        if (parserFactory == null) {
            parserFactory = SAXParserFactory.newInstance();
        }
        return parserFactory;
    }

    private void configureId(Object target, Attributes attr) {
        String id = attr.getValue("id");
        if (id != null) {
            this.project.addReference(id, target);
        }
    }

    public static AttributeList sax1Attributes(Attributes sax2Att) {
        AttributeListImpl sax1Att = new AttributeListImpl();
        int length = sax2Att.getLength();
        if (length > 0) {
            int i = 0;
            while (i < length) {
                sax1Att.addAttribute(sax2Att.getQName(i), sax2Att.getType(i), sax2Att.getValue(i));
                ++i;
            }
        }
        return sax1Att;
    }

    private class DataTypeHandler
    extends AbstractHandler {
        private Target target;
        private Object element;
        private RuntimeConfigurable wrapper = null;

        public DataTypeHandler(DefaultHandler parentHandler) {
            this(parentHandler, null);
        }

        public DataTypeHandler(DefaultHandler parentHandler, Target target) {
            super(parentHandler);
            this.target = target;
        }

        public void init(String propType, Attributes attrs) throws SAXParseException {
            try {
                this.element = ProjectHelperImpl20.this.project.createDataType(propType);
                if (this.element == null) {
                    throw new BuildException("Unknown data type " + propType);
                }
                if (this.target != null) {
                    this.wrapper = new RuntimeConfigurable(this.element, propType);
                    this.wrapper.setAttributes(ProjectHelperImpl20.sax1Attributes(attrs));
                    this.target.addDataType(this.wrapper);
                } else {
                    ProjectHelper.configure((Object)this.element, (AttributeList)ProjectHelperImpl20.sax1Attributes(attrs), (Project)ProjectHelperImpl20.this.project);
                    ProjectHelperImpl20.this.configureId(this.element, attrs);
                }
            }
            catch (BuildException exc) {
                throw new SAXParseException(exc.getMessage(), ProjectHelperImpl20.this.locator, (Exception)((Object)exc));
            }
        }

        public void characters(char[] buf, int start, int count) throws SAXParseException {
            try {
                ProjectHelper.addText((Project)ProjectHelperImpl20.this.project, (Object)this.element, (char[])buf, (int)start, (int)count);
            }
            catch (BuildException exc) {
                throw new SAXParseException(exc.getMessage(), ProjectHelperImpl20.this.locator, (Exception)((Object)exc));
            }
        }

        public void startElement(String uri, String name, String qname, Attributes attrs) throws SAXParseException {
            new NestedElementHandler(this, this.element, this.wrapper, this.target).init(qname, attrs);
        }
    }

    private class NestedElementHandler
    extends AbstractHandler {
        private Object parent;
        private Object child;
        private RuntimeConfigurable parentWrapper;
        private RuntimeConfigurable childWrapper = null;
        private Target target;

        public NestedElementHandler(DefaultHandler parentHandler, Object parent, RuntimeConfigurable parentWrapper, Target target) {
            super(parentHandler);
            this.parent = parent instanceof TaskAdapter ? ((TaskAdapter)parent).getProxy() : parent;
            this.parentWrapper = parentWrapper;
            this.target = target;
        }

        public void init(String propType, Attributes attrs) throws SAXParseException {
            Class<?> parentClass = this.parent.getClass();
            IntrospectionHelper ih = IntrospectionHelper.getHelper(parentClass);
            try {
                String elementName = propType.toLowerCase(Locale.US);
                if (this.parent instanceof UnknownElement) {
                    UnknownElement uc = new UnknownElement(elementName);
                    uc.setProject(ProjectHelperImpl20.this.project);
                    ((UnknownElement)this.parent).addChild(uc);
                    this.child = uc;
                } else {
                    this.child = ih.createElement(ProjectHelperImpl20.this.project, this.parent, elementName);
                }
                ProjectHelperImpl20.this.configureId(this.child, attrs);
                if (this.parentWrapper != null) {
                    this.childWrapper = new RuntimeConfigurable(this.child, propType);
                    this.childWrapper.setAttributes(ProjectHelperImpl20.sax1Attributes(attrs));
                    this.parentWrapper.addChild(this.childWrapper);
                } else {
                    ProjectHelper.configure((Object)this.child, (AttributeList)ProjectHelperImpl20.sax1Attributes(attrs), (Project)ProjectHelperImpl20.this.project);
                    ih.storeElement(ProjectHelperImpl20.this.project, this.parent, this.child, elementName);
                }
            }
            catch (BuildException exc) {
                throw new SAXParseException(exc.getMessage(), ProjectHelperImpl20.this.locator, (Exception)((Object)exc));
            }
        }

        public void characters(char[] buf, int start, int count) throws SAXParseException {
            if (this.parentWrapper == null) {
                try {
                    ProjectHelper.addText((Project)ProjectHelperImpl20.this.project, (Object)this.child, (char[])buf, (int)start, (int)count);
                }
                catch (BuildException exc) {
                    throw new SAXParseException(exc.getMessage(), ProjectHelperImpl20.this.locator, (Exception)((Object)exc));
                }
            } else {
                this.childWrapper.addText(buf, start, count);
            }
        }

        public void startElement(String uri, String name, String qname, Attributes attrs) throws SAXParseException {
            if (this.child instanceof TaskContainer) {
                new TaskHandler(this, (TaskContainer)this.child, this.childWrapper, this.target).init(qname, attrs);
            } else {
                new NestedElementHandler(this, this.child, this.childWrapper, this.target).init(qname, attrs);
            }
        }
    }

    private class TaskHandler
    extends AbstractHandler {
        private Target target;
        private TaskContainer container;
        private Task task;
        private RuntimeConfigurable parentWrapper;
        private RuntimeConfigurable wrapper = null;

        public TaskHandler(DefaultHandler parentHandler, TaskContainer container, RuntimeConfigurable parentWrapper, Target target) {
            super(parentHandler);
            this.container = container;
            this.parentWrapper = parentWrapper;
            this.target = target;
        }

        public void init(String tag, Attributes attrs) throws SAXParseException {
            try {
                this.task = ProjectHelperImpl20.this.project.createTask(tag);
            }
            catch (BuildException buildException) {
                // empty catch block
            }
            if (this.task == null) {
                this.task = new UnknownElement(tag);
                this.task.setProject(ProjectHelperImpl20.this.project);
                this.task.setTaskName(tag);
            }
            this.task.setLocation(new Location(ProjectHelperImpl20.this.buildFile.toString(), ProjectHelperImpl20.this.locator.getLineNumber(), ProjectHelperImpl20.this.locator.getColumnNumber()));
            ProjectHelperImpl20.this.configureId(this.task, attrs);
            if (this.target != null) {
                this.task.setOwningTarget(this.target);
                this.container.addTask(this.task);
                this.task.init();
                this.wrapper = this.task.getRuntimeConfigurableWrapper();
                this.wrapper.setAttributes(ProjectHelperImpl20.sax1Attributes(attrs));
                if (this.parentWrapper != null) {
                    this.parentWrapper.addChild(this.wrapper);
                }
            } else {
                this.task.init();
                ProjectHelper.configure((Object)this.task, (AttributeList)ProjectHelperImpl20.sax1Attributes(attrs), (Project)ProjectHelperImpl20.this.project);
            }
        }

        protected void finished() {
            if (this.task != null && this.target == null) {
                this.task.execute();
            }
        }

        public void characters(char[] buf, int start, int count) throws SAXParseException {
            if (this.wrapper == null) {
                try {
                    ProjectHelper.addText((Project)ProjectHelperImpl20.this.project, (Object)this.task, (char[])buf, (int)start, (int)count);
                }
                catch (BuildException exc) {
                    throw new SAXParseException(exc.getMessage(), ProjectHelperImpl20.this.locator, (Exception)((Object)exc));
                }
            } else {
                this.wrapper.addText(buf, start, count);
            }
        }

        public void startElement(String uri, String name, String qname, Attributes attrs) throws SAXParseException {
            if (this.task instanceof TaskContainer) {
                new TaskHandler(this, (TaskContainer)this.task, this.wrapper, this.target).init(qname, attrs);
            } else {
                new NestedElementHandler(this, this.task, this.wrapper, this.target).init(qname, attrs);
            }
        }
    }

    private class TargetHandler
    extends AbstractHandler {
        private Target target;

        public TargetHandler(DefaultHandler parentHandler) {
            super(parentHandler);
        }

        public void init(String tag, Attributes attrs) throws SAXParseException {
            String name = null;
            String depends = "";
            String ifCond = null;
            String unlessCond = null;
            String id = null;
            String description = null;
            int i = 0;
            while (i < attrs.getLength()) {
                String key = attrs.getQName(i);
                String value = attrs.getValue(i);
                if (key.equals("name")) {
                    name = value;
                } else if (key.equals("depends")) {
                    depends = value;
                } else if (key.equals("if")) {
                    ifCond = value;
                } else if (key.equals("unless")) {
                    unlessCond = value;
                } else if (key.equals("id")) {
                    id = value;
                } else if (key.equals("description")) {
                    description = value;
                } else {
                    throw new SAXParseException("Unexpected attribute \"" + key + "\"", ProjectHelperImpl20.this.locator);
                }
                ++i;
            }
            if (name == null) {
                throw new SAXParseException("target element appears without a name attribute", ProjectHelperImpl20.this.locator);
            }
            this.target = new Target();
            this.target.setName(name);
            this.target.setIf(ifCond);
            this.target.setUnless(unlessCond);
            this.target.setDescription(description);
            ProjectHelperImpl20.this.project.addTarget(name, this.target);
            if (id != null && !id.equals("")) {
                ProjectHelperImpl20.this.project.addReference(id, (Object)this.target);
            }
            if (depends.length() > 0) {
                this.target.setDepends(depends);
            }
        }

        public void startElement(String uri, String name, String qname, Attributes attrs) throws SAXParseException {
            if (ProjectHelperImpl20.this.project.getDataTypeDefinitions().get(qname) != null) {
                new DataTypeHandler(this, this.target).init(qname, attrs);
            } else {
                new TaskHandler(this, (TaskContainer)this.target, null, this.target).init(qname, attrs);
            }
        }
    }

    private class ProjectHandler
    extends AbstractHandler {
        public ProjectHandler(DefaultHandler parentHandler) {
            super(parentHandler);
        }

        public void init(String tag, Attributes attrs) throws SAXParseException {
            String def = null;
            String name = null;
            String id = null;
            String baseDir = null;
            int i = 0;
            while (i < attrs.getLength()) {
                String key = attrs.getQName(i);
                String value = attrs.getValue(i);
                if (key.equals("default")) {
                    def = value;
                } else if (key.equals("name")) {
                    name = value;
                } else if (key.equals("id")) {
                    id = value;
                } else if (key.equals("basedir")) {
                    baseDir = value;
                } else {
                    throw new SAXParseException("Unexpected attribute \"" + attrs.getQName(i) + "\"", ProjectHelperImpl20.this.locator);
                }
                ++i;
            }
            if (def == null) {
                throw new SAXParseException("The default attribute of project is required", ProjectHelperImpl20.this.locator);
            }
            ProjectHelperImpl20.this.project.setDefaultTarget(def);
            if (name != null) {
                ProjectHelperImpl20.this.project.setName(name);
                ProjectHelperImpl20.this.project.addReference(name, (Object)ProjectHelperImpl20.this.project);
            }
            if (id != null) {
                ProjectHelperImpl20.this.project.addReference(id, (Object)ProjectHelperImpl20.this.project);
            }
            if (ProjectHelperImpl20.this.project.getProperty("basedir") != null) {
                ProjectHelperImpl20.this.project.setBasedir(ProjectHelperImpl20.this.project.getProperty("basedir"));
            } else if (baseDir == null) {
                ProjectHelperImpl20.this.project.setBasedir(ProjectHelperImpl20.this.buildFileParent.getAbsolutePath());
            } else if (new File(baseDir).isAbsolute()) {
                ProjectHelperImpl20.this.project.setBasedir(baseDir);
            } else {
                ProjectHelperImpl20.this.project.setBaseDir(ProjectHelperImpl20.this.project.resolveFile(baseDir, ProjectHelperImpl20.this.buildFileParent));
            }
        }

        public void startElement(String uri, String name, String qname, Attributes attrs) throws SAXParseException {
            if (qname.equals("taskdef")) {
                this.handleTaskdef(qname, attrs);
            } else if (qname.equals("typedef")) {
                this.handleTypedef(qname, attrs);
            } else if (qname.equals("property")) {
                this.handleProperty(qname, attrs);
            } else if (qname.equals("target")) {
                this.handleTarget(qname, attrs);
            } else if (ProjectHelperImpl20.this.project.getDataTypeDefinitions().get(qname) != null) {
                this.handleDataType(qname, attrs);
            } else {
                throw new SAXParseException("Unexpected element \"" + qname + "\"", ProjectHelperImpl20.this.locator);
            }
        }

        private void handleTaskdef(String name, Attributes attrs) throws SAXParseException {
            new TaskHandler(this, null, null, null).init(name, attrs);
        }

        private void handleTypedef(String name, Attributes attrs) throws SAXParseException {
            new TaskHandler(this, null, null, null).init(name, attrs);
        }

        private void handleProperty(String name, Attributes attrs) throws SAXParseException {
            new TaskHandler(this, null, null, null).init(name, attrs);
        }

        private void handleTarget(String tag, Attributes attrs) throws SAXParseException {
            new TargetHandler(this).init(tag, attrs);
        }

        private void handleDataType(String name, Attributes attrs) throws SAXParseException {
            new DataTypeHandler(this).init(name, attrs);
        }
    }

    private class RootHandler
    extends DefaultHandler {
        private RootHandler() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            ProjectHelperImpl20.this.project.log("resolving systemId: " + systemId, 3);
            if (systemId.startsWith("file:")) {
                String path = systemId.substring(5);
                int index = path.indexOf("file:");
                while (index != -1) {
                    path = path.substring(0, index) + path.substring(index + 5);
                    index = path.indexOf("file:");
                }
                String entitySystemId = path;
                index = path.indexOf("%23");
                while (index != -1) {
                    path = path.substring(0, index) + "#" + path.substring(index + 3);
                    index = path.indexOf("%23");
                }
                File file = new File(path);
                if (!file.isAbsolute()) {
                    file = new File(ProjectHelperImpl20.this.buildFileParent, path);
                }
                try {
                    InputSource inputSource = new InputSource(new FileInputStream(file));
                    inputSource.setSystemId("file:" + entitySystemId);
                    return inputSource;
                }
                catch (FileNotFoundException fne) {
                    ProjectHelperImpl20.this.project.log(file.getAbsolutePath() + " could not be found", 1);
                }
            }
            return null;
        }

        public void startElement(String uri, String tag, String qname, Attributes attrs) throws SAXParseException {
            if (!qname.equals("project")) {
                throw new SAXParseException("Config file is not of expected XML type", ProjectHelperImpl20.this.locator);
            }
            new ProjectHandler(this).init(qname, attrs);
        }

        public void setDocumentLocator(Locator locator) {
            ProjectHelperImpl20.this.locator = locator;
        }
    }

    private class AbstractHandler
    extends DefaultHandler {
        protected DefaultHandler parentHandler;

        public AbstractHandler(DefaultHandler parentHandler) {
            this.parentHandler = parentHandler;
            ProjectHelperImpl20.this.parser.setContentHandler(this);
        }

        public void startElement(String uri, String tag, String qname, Attributes attrs) throws SAXParseException {
            throw new SAXParseException("Unexpected element \"" + qname + "\"", ProjectHelperImpl20.this.locator);
        }

        public void characters(char[] buf, int start, int count) throws SAXParseException {
            String s = new String(buf, start, count).trim();
            if (s.length() > 0) {
                throw new SAXParseException("Unexpected text \"" + s + "\"", ProjectHelperImpl20.this.locator);
            }
        }

        protected void finished() {
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            this.finished();
            ProjectHelperImpl20.this.parser.setContentHandler(this.parentHandler);
        }
    }
}

