/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import java.io.OutputStream;
import org.apache.avalon.excalibur.logger.factory.AbstractTargetFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.log.LogTarget;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.format.RawFormatter;
import org.apache.log.output.io.StreamTarget;

public class StreamTargetFactory
extends AbstractTargetFactory
implements Contextualizable {
    private static final String FORMAT = "%7.7{priority} %5.5{time}   [%8.8{category}] (%{context}): %{message}\\n%{throwable}";

    /*
     * WARNING - void declaration
     */
    public LogTarget createTarget(Configuration configuration) throws ConfigurationException {
        void stream;
        OutputStream outputStream;
        Configuration streamConfig = configuration.getChild("stream", false);
        if (streamConfig == null) {
            outputStream = System.err;
        } else {
            String streamName = streamConfig.getValue();
            try {
                outputStream = (OutputStream)this.m_context.get((Object)streamName);
            }
            catch (Exception e) {
                throw new ConfigurationException("Error resolving stream '" + streamName + "' at " + streamConfig.getLocation(), (Throwable)e);
            }
        }
        Formatter formatter = this.getFormatter(configuration.getChild("format"));
        return new StreamTarget((OutputStream)stream, formatter);
    }

    protected Formatter getFormatter(Configuration conf) {
        String type = conf.getAttribute("type", "pattern");
        String format = conf.getValue(FORMAT);
        if ("extended".equals(type)) {
            return new ExtendedPatternFormatter(format);
        }
        if ("raw".equals(type)) {
            return new RawFormatter();
        }
        return new PatternFormatter(format);
    }

    public void contextualize(Context context) throws ContextException {
        DefaultContext newContext = new DefaultContext(context);
        newContext.put((Object)"System.out", (Object)System.out);
        newContext.put((Object)"System.err", (Object)System.err);
        super.contextualize((Context)newContext);
    }
}

