/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.parameters;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.ParameterException;

public class Parameters
implements Serializable {
    public static final Parameters EMPTY_PARAMETERS = new Parameters();
    private Map m_parameters = new HashMap();
    private boolean m_readOnly;

    public String setParameter(String name, String value) throws IllegalStateException {
        this.checkWriteable();
        if (name == null) {
            return null;
        }
        if (value == null) {
            return (String)this.m_parameters.remove(name);
        }
        return this.m_parameters.put(name, value);
    }

    public void removeParameter(String name) {
        this.setParameter(name, null);
    }

    public Iterator getParameterNames() {
        return this.m_parameters.keySet().iterator();
    }

    public String[] getNames() {
        return this.m_parameters.keySet().toArray(new String[0]);
    }

    public boolean isParameter(String name) {
        return this.m_parameters.containsKey(name);
    }

    public String getParameter(String name) throws ParameterException {
        if (name == null) {
            throw new ParameterException("You cannot lookup a null parameter");
        }
        String test = (String)this.m_parameters.get(name);
        if (test == null) {
            throw new ParameterException("The parameter '" + name + "' does not contain a value");
        }
        return test;
    }

    public String getParameter(String name, String defaultValue) {
        try {
            return this.getParameter(name);
        }
        catch (ParameterException pe) {
            return defaultValue;
        }
    }

    public int getParameterAsInteger(String name) throws ParameterException {
        try {
            String value = this.getParameter(name);
            if (value.startsWith("0x")) {
                return Integer.parseInt(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Integer.parseInt(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Integer.parseInt(value.substring(2), 2);
            }
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new ParameterException("Could not return an integer value", e);
        }
    }

    public int getParameterAsInteger(String name, int defaultValue) {
        try {
            return this.getParameterAsInteger(name);
        }
        catch (ParameterException pe) {
            return defaultValue;
        }
    }

    public long getParameterAsLong(String name) throws ParameterException {
        try {
            String value = this.getParameter(name);
            if (value.startsWith("0x")) {
                return Long.parseLong(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Long.parseLong(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Long.parseLong(value.substring(2), 2);
            }
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new ParameterException("Could not return a long value", e);
        }
    }

    public long getParameterAsLong(String name, long defaultValue) {
        try {
            return this.getParameterAsLong(name);
        }
        catch (ParameterException pe) {
            return defaultValue;
        }
    }

    public float getParameterAsFloat(String name) throws ParameterException {
        try {
            return Float.parseFloat(this.getParameter(name));
        }
        catch (Exception e) {
            throw new ParameterException("Could not return a float value", e);
        }
    }

    public float getParameterAsFloat(String name, float defaultValue) {
        try {
            return this.getParameterAsFloat(name);
        }
        catch (ParameterException pe) {
            return defaultValue;
        }
    }

    public boolean getParameterAsBoolean(String name) throws ParameterException {
        String value = this.getParameter(name);
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ParameterException("Could not return a boolean value");
    }

    public boolean getParameterAsBoolean(String name, boolean defaultValue) {
        try {
            return this.getParameterAsBoolean(name);
        }
        catch (ParameterException e) {
            return defaultValue;
        }
    }

    public Parameters merge(Parameters other) {
        this.checkWriteable();
        Iterator names = other.getParameterNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            String value = null;
            try {
                value = other.getParameter(name);
            }
            catch (ParameterException pe) {
                value = null;
            }
            this.setParameter(name, value);
        }
        return this;
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("Context is read only and can not be modified");
        }
    }

    public static Parameters fromConfiguration(Configuration configuration) throws ConfigurationException {
        return Parameters.fromConfiguration(configuration, "parameter");
    }

    public static Parameters fromConfiguration(Configuration configuration, String elementName) throws ConfigurationException {
        if (configuration == null) {
            throw new ConfigurationException("You cannot convert to parameters with a null Configuration");
        }
        Configuration[] parameters = configuration.getChildren(elementName);
        Parameters params = new Parameters();
        int i = 0;
        while (i < parameters.length) {
            try {
                String name = parameters[i].getAttribute("name");
                String value = parameters[i].getAttribute("value");
                params.setParameter(name, value);
            }
            catch (Exception e) {
                throw new ConfigurationException("Cannot process Configurable", e);
            }
            ++i;
        }
        return params;
    }

    public static Parameters fromProperties(Properties properties) {
        Parameters parameters = new Parameters();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String key = names.nextElement().toString();
            String value = properties.getProperty(key);
            parameters.setParameter(key, value);
        }
        return parameters;
    }

    static {
        EMPTY_PARAMETERS.makeReadOnly();
    }
}

