/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import org.apache.log.Category;
import org.apache.log.LogEntry;
import org.apache.log.LogKit;
import org.apache.log.LogTarget;
import org.apache.log.Priority;

public class Logger {
    protected static final long START_TIME = System.currentTimeMillis();
    protected final Logger m_parent;
    protected final Category m_category;
    protected LogTarget[] m_logTargets;

    public final void debug(String message, Throwable throwable) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.DEBUG) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.DEBUG)) {
            this.output(Priority.DEBUG, message, throwable);
        }
    }

    public final void debug(String message) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.DEBUG) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.DEBUG)) {
            this.output(Priority.DEBUG, message, null);
        }
    }

    public final void error(String message, Throwable throwable) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.ERROR) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.ERROR)) {
            this.output(Priority.ERROR, message, throwable);
        }
    }

    public final void error(String message) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.ERROR) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.ERROR)) {
            this.output(Priority.ERROR, message, null);
        }
    }

    public final void fatalError(String message, Throwable throwable) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.FATAL_ERROR) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.FATAL_ERROR)) {
            this.output(Priority.FATAL_ERROR, message, throwable);
        }
    }

    public final void fatalError(String message) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.FATAL_ERROR) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.FATAL_ERROR)) {
            this.output(Priority.FATAL_ERROR, message, null);
        }
    }

    public final Category getCategory() {
        return this.m_category;
    }

    public final void info(String message) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.INFO) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.INFO)) {
            this.output(Priority.INFO, message, null);
        }
    }

    public final void log(Priority.Enum priority, String message, Throwable throwable) {
        if (this.m_category.getPriority().isLowerOrEqual(priority) && LogKit.getGlobalPriority().isLowerOrEqual(priority)) {
            this.output(priority, message, throwable);
        }
    }

    public final void log(Priority.Enum priority, String message) {
        if (this.m_category.getPriority().isLowerOrEqual(priority) && LogKit.getGlobalPriority().isLowerOrEqual(priority)) {
            this.output(priority, message, null);
        }
    }

    private final void output(Priority.Enum priority, String message, Throwable throwable) {
        LogEntry entry = new LogEntry();
        entry.setCategory(this.m_category);
        entry.setContextStack(LogKit.getCurrentContext());
        if (message != null) {
            entry.setMessage(message);
        } else {
            entry.setMessage("");
        }
        entry.setThrowable(throwable);
        entry.setPriority(priority);
        entry.setTime(System.currentTimeMillis() - START_TIME);
        this.output(entry);
    }

    protected final void output(LogEntry entry) {
        LogTarget[] targets = this.m_logTargets;
        if (targets == null) {
            if (this.m_parent != null) {
                this.m_parent.output(entry);
            } else {
                LogKit.getDefaultLogTarget().processEntry(entry);
            }
        } else {
            int i = 0;
            while (i < targets.length) {
                targets[i].processEntry(entry);
                ++i;
            }
        }
    }

    public final void warn(String message, Throwable throwable) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.WARN) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.WARN)) {
            this.output(Priority.WARN, message, throwable);
        }
    }

    public final void warn(String message) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.WARN) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.WARN)) {
            this.output(Priority.WARN, message, null);
        }
    }

    public void setLogTargets(LogTarget[] logTargets) {
        this.m_logTargets = logTargets;
    }

    public final LogTarget[] getLogTargets() {
        return this.m_logTargets;
    }

    public final void addLogTarget(LogTarget target) {
        if (this.m_logTargets == null) {
            this.m_logTargets = new LogTarget[]{target};
        } else {
            LogTarget[] targets = new LogTarget[this.m_logTargets.length + 1];
            System.arraycopy(this.m_logTargets, 0, targets, 0, this.m_logTargets.length);
            targets[this.m_logTargets.length] = target;
            this.m_logTargets = targets;
        }
    }

    public Logger getChildLogger(String subcategory) {
        String categoryName = this.m_category.getName() + "." + subcategory;
        return LogKit.getLoggerFor(categoryName);
    }

    public Logger(Category category) {
        this(category, null, null);
    }

    public Logger(Category category, LogTarget[] logTargets) {
        this(category, logTargets, null);
    }

    public Logger(Category category, LogTarget[] logTargets, Logger parent) {
        this.m_category = category;
        this.m_logTargets = logTargets;
        this.m_parent = parent;
    }

    public Logger(Category category, Logger parent) {
        this(category, null, parent);
    }
}

