/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.ObjectPool;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.Expression;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ContextNodeList;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class UnionPathIterator
extends Expression
implements Cloneable,
NodeIterator,
ContextNodeList {
    transient ObjectPool m_pool = new ObjectPool(this.getClass());
    transient NodeSet m_cachedNodes = null;
    protected transient int m_next = 0;
    transient Node m_lastFetched;
    protected transient boolean m_foundLast = false;
    protected transient XPathContext m_execContext;
    protected transient Node m_context;
    protected transient Node m_currentContextNode;
    protected LocPathIterator[] m_iterators;
    private transient int m_last = 0;

    public UnionPathIterator() {
        this.m_iterators = null;
    }

    public UnionPathIterator(Compiler compiler, int n) throws TransformerException {
        n = OpMap.getFirstChildPos(n);
        this.loadLocationPaths(compiler, n, 0);
    }

    public void addIterator(LocPathIterator locPathIterator) {
        if (this.m_iterators == null) {
            this.m_iterators = new LocPathIterator[1];
            this.m_iterators[0] = locPathIterator;
        } else {
            LocPathIterator[] locPathIteratorArray = this.m_iterators;
            int n = this.m_iterators.length;
            this.m_iterators = new LocPathIterator[n + 1];
            System.arraycopy(locPathIteratorArray, 0, this.m_iterators, 0, n);
            this.m_iterators[n] = locPathIterator;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        UnionPathIterator unionPathIterator = (UnionPathIterator)super.clone();
        int n = this.m_iterators.length;
        unionPathIterator.m_iterators = new LocPathIterator[n];
        int n2 = 0;
        while (n2 < n) {
            unionPathIterator.m_iterators[n2] = (LocPathIterator)this.m_iterators[n2].clone();
            ++n2;
        }
        return unionPathIterator;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        UnionPathIterator unionPathIterator = (UnionPathIterator)this.clone();
        unionPathIterator.reset();
        return unionPathIterator;
    }

    protected LocPathIterator createLocPathIterator(Compiler compiler, int n) throws TransformerException {
        LocPathIterator locPathIterator = WalkerFactory.newLocPathIterator(compiler, n);
        if (compiler.getLocationPathDepth() <= 0) {
            locPathIterator.setIsTopLevel(true);
        }
        return locPathIterator;
    }

    public void detach() {
        this.m_context = null;
        this.m_execContext = null;
        this.m_context = null;
        int n = this.m_iterators.length;
        int n2 = 0;
        while (n2 < n) {
            this.m_iterators[n2].detach();
            ++n2;
        }
        this.m_pool.freeInstance(this);
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        try {
            UnionPathIterator unionPathIterator = (UnionPathIterator)this.m_pool.getInstanceIfFree();
            if (unionPathIterator == null) {
                unionPathIterator = (UnionPathIterator)this.clone();
            }
            unionPathIterator.initContext(xPathContext);
            return new XNodeSet(unionPathIterator);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Node getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public Node getCurrentNode() {
        return this.m_lastFetched;
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public int getLast() {
        return this.m_last;
    }

    public Node getRoot() {
        return this.m_context;
    }

    public int getWhatToShow() {
        return -17;
    }

    public void initContext(XPathContext xPathContext) {
        this.m_execContext = xPathContext;
        this.m_currentContextNode = xPathContext.getCurrentExpressionNode();
        this.m_context = xPathContext.getCurrentNode();
        if (this.m_iterators != null) {
            int n = this.m_iterators.length;
            int n2 = 0;
            while (n2 < n) {
                this.m_iterators[n2].initContext(xPathContext);
                this.m_iterators[n2].nextNode();
                ++n2;
            }
        }
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    protected void loadLocationPaths(Compiler compiler, int n, int n2) throws TransformerException {
        int n3 = compiler.getOpMap()[n];
        if (n3 == 28) {
            this.loadLocationPaths(compiler, compiler.getNextOpPos(n), n2 + 1);
            this.m_iterators[n2] = this.createLocPathIterator(compiler, n);
        } else {
            switch (n3) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.loadLocationPaths(compiler, compiler.getNextOpPos(n), n2 + 1);
                    LocPathIterator locPathIterator = new LocPathIterator(compiler.getNamespaceContext());
                    if (compiler.getLocationPathDepth() <= 0) {
                        locPathIterator.setIsTopLevel(true);
                    }
                    locPathIterator.m_firstWalker = new FilterExprWalker(locPathIterator);
                    locPathIterator.m_firstWalker.init(compiler, n, n3);
                    this.m_iterators[n2] = locPathIterator;
                    break;
                }
                default: {
                    this.m_iterators = new LocPathIterator[n2];
                }
            }
        }
    }

    public Node nextNode() throws DOMException {
        if (this.m_cachedNodes != null && this.m_cachedNodes.getCurrentPos() < this.m_cachedNodes.size()) {
            return this.m_cachedNodes.nextNode();
        }
        if (this.m_foundLast) {
            return null;
        }
        Node node = null;
        if (this.m_iterators != null) {
            int n = this.m_iterators.length;
            int n2 = -1;
            int n3 = 0;
            while (n3 < n) {
                Node node2 = this.m_iterators[n3].getCurrentNode();
                if (node2 != null) {
                    if (node == null) {
                        n2 = n3;
                        node = node2;
                    } else if (node2.equals(node)) {
                        this.m_iterators[n3].nextNode();
                    } else {
                        DOMHelper dOMHelper = this.m_execContext.getDOMHelper();
                        if (dOMHelper.isNodeAfter(node2, node)) {
                            n2 = n3;
                            node = node2;
                        }
                    }
                }
                ++n3;
            }
            if (node != null) {
                this.m_iterators[n2].nextNode();
                if (this.m_cachedNodes != null) {
                    this.m_cachedNodes.addElement(node);
                }
                ++this.m_next;
            } else {
                this.m_foundLast = true;
            }
        }
        this.m_lastFetched = node;
        return node;
    }

    public Node previousNode() throws DOMException {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSet can not iterate to a previous node!");
        }
        return this.m_cachedNodes.previousNode();
    }

    public void reset() {
        this.m_foundLast = false;
        this.m_next = 0;
        this.m_last = 0;
        this.m_lastFetched = null;
        int n = this.m_iterators.length;
        int n2 = 0;
        while (n2 < n) {
            this.m_iterators[n2].reset();
            this.m_iterators[n2].nextNode();
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void runTo(int var1_1) {
        if (!this.m_foundLast && (var1_1 < 0 || var1_1 > this.m_next)) ** GOTO lbl-1000
        return;
        while (this.m_next < var1_1) lbl-1000:
        // 2 sources

        {
            if ((var2_2 = this.nextNode()) == null) continue;
        }
    }

    public void setCurrentPos(int n) {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.m_next = n;
        this.m_cachedNodes.setCurrentPos(n);
    }

    public void setLast(int n) {
        this.m_last = n;
    }

    public void setShouldCacheNodes(boolean bl) {
        this.m_cachedNodes = bl ? new NodeSet() : null;
    }

    public int size() {
        if (this.m_cachedNodes == null) {
            return 0;
        }
        return this.m_cachedNodes.size();
    }
}

