/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.tar;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.excalibur.tar.TarBuffer;
import org.apache.excalibur.tar.TarEntry;

public class TarOutputStream
extends FilterOutputStream {
    public static final int LONGFILE_ERROR = 0;
    public static final int LONGFILE_TRUNCATE = 1;
    public static final int LONGFILE_GNU = 2;
    private int m_longFileMode = 0;
    private byte[] m_assemBuf;
    private int m_assemLen;
    private TarBuffer m_buffer;
    private int m_currBytes;
    private int m_currSize;
    private byte[] m_oneBuf;
    private byte[] m_recordBuf;

    public TarOutputStream(OutputStream output) {
        this(output, 10240, 512);
    }

    public TarOutputStream(OutputStream output, int blockSize) {
        this(output, blockSize, 512);
    }

    public TarOutputStream(OutputStream output, int blockSize, int recordSize) {
        super(output);
        this.m_buffer = new TarBuffer(output, blockSize, recordSize);
        this.m_assemLen = 0;
        this.m_assemBuf = new byte[recordSize];
        this.m_recordBuf = new byte[recordSize];
        this.m_oneBuf = new byte[1];
    }

    public void setBufferDebug(boolean debug) {
        this.m_buffer.setDebug(debug);
    }

    public void setLongFileMode(int longFileMode) {
        if (0 != longFileMode && 2 != longFileMode && 1 != longFileMode) {
            throw new IllegalArgumentException("longFileMode");
        }
        this.m_longFileMode = longFileMode;
    }

    public int getRecordSize() {
        return this.m_buffer.getRecordSize();
    }

    public void close() throws IOException {
        this.finish();
        this.m_buffer.close();
    }

    public void closeEntry() throws IOException {
        if (this.m_assemLen > 0) {
            int i = this.m_assemLen;
            while (i < this.m_assemBuf.length) {
                this.m_assemBuf[i] = 0;
                ++i;
            }
            this.m_buffer.writeRecord(this.m_assemBuf);
            this.m_currBytes += this.m_assemLen;
            this.m_assemLen = 0;
        }
        if (this.m_currBytes < this.m_currSize) {
            String message = "entry closed at '" + this.m_currBytes + "' before the '" + this.m_currSize + "' bytes specified in the header were written";
            throw new IOException(message);
        }
    }

    public void finish() throws IOException {
        this.writeEOFRecord();
    }

    public void putNextEntry(TarEntry entry) throws IOException {
        if (entry.getName().length() >= 100) {
            if (this.m_longFileMode == 2) {
                TarEntry longLinkEntry = new TarEntry("././@LongLink", 76);
                longLinkEntry.setSize(entry.getName().length());
                this.putNextEntry(longLinkEntry);
                this.write(entry.getName().getBytes());
                this.closeEntry();
            } else if (this.m_longFileMode != 1) {
                String message = "file name '" + entry.getName() + "' is too long ( > " + 100 + " bytes)";
                throw new IOException(message);
            }
        }
        entry.writeEntryHeader(this.m_recordBuf);
        this.m_buffer.writeRecord(this.m_recordBuf);
        this.m_currBytes = 0;
        this.m_currSize = entry.isDirectory() ? 0 : (int)entry.getSize();
    }

    public void copyEntryContents(InputStream input) throws IOException {
        int numRead;
        byte[] buffer = new byte[32768];
        while ((numRead = input.read(buffer, 0, buffer.length)) != -1) {
            this.write(buffer, 0, numRead);
        }
    }

    public void write(int data) throws IOException {
        this.m_oneBuf[0] = (byte)data;
        this.write(this.m_oneBuf, 0, 1);
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int offset, int count) throws IOException {
        int position = offset;
        int numToWrite = count;
        if (this.m_currBytes + numToWrite > this.m_currSize) {
            String message = "request to write '" + numToWrite + "' bytes exceeds size in header of '" + this.m_currSize + "' bytes";
            throw new IOException(message);
        }
        if (this.m_assemLen > 0) {
            if (this.m_assemLen + numToWrite >= this.m_recordBuf.length) {
                int length = this.m_recordBuf.length - this.m_assemLen;
                System.arraycopy(this.m_assemBuf, 0, this.m_recordBuf, 0, this.m_assemLen);
                System.arraycopy(buffer, position, this.m_recordBuf, this.m_assemLen, length);
                this.m_buffer.writeRecord(this.m_recordBuf);
                this.m_currBytes += this.m_recordBuf.length;
                position += length;
                numToWrite -= length;
                this.m_assemLen = 0;
            } else {
                System.arraycopy(buffer, position, this.m_assemBuf, this.m_assemLen, numToWrite);
                position += numToWrite;
                this.m_assemLen += numToWrite;
                numToWrite -= numToWrite;
            }
        }
        while (numToWrite > 0) {
            if (numToWrite < this.m_recordBuf.length) {
                System.arraycopy(buffer, position, this.m_assemBuf, this.m_assemLen, numToWrite);
                this.m_assemLen += numToWrite;
                break;
            }
            this.m_buffer.writeRecord(buffer, position);
            int num = this.m_recordBuf.length;
            this.m_currBytes += num;
            numToWrite -= num;
            position += num;
        }
    }

    private void writeEOFRecord() throws IOException {
        int i = 0;
        while (i < this.m_recordBuf.length) {
            this.m_recordBuf[i] = 0;
            ++i;
        }
        this.m_buffer.writeRecord(this.m_recordBuf);
    }
}

