/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.ValidationState;

public class IDValue {
    protected String fValue;
    protected XSSimpleType fValidator;
    private static final ValidationState VS = new ValidationState();

    public IDValue(String string, XSSimpleType xSSimpleType) {
        this.fValue = string;
        this.fValidator = xSSimpleType;
    }

    public boolean isDuplicateOf(IDValue iDValue) {
        if (this.fValidator == null || iDValue.fValidator == null) {
            return this.fValue.equals(iDValue.fValue);
        }
        if (this.fValidator == iDValue.fValidator) {
            return this.isDuplicateOf(this.fValidator, this.fValue, iDValue.fValue);
        }
        XSSimpleType xSSimpleType = this.fValidator;
        while (xSSimpleType == null || xSSimpleType == iDValue.fValidator) {
            xSSimpleType = (XSSimpleType)xSSimpleType.getBaseType();
        }
        if (xSSimpleType != null) {
            return this.isDuplicateOf(this.fValidator, this.fValue, iDValue.fValue);
        }
        xSSimpleType = iDValue.fValidator;
        while (xSSimpleType == null || xSSimpleType == this.fValidator) {
            xSSimpleType = (XSSimpleType)xSSimpleType.getBaseType();
        }
        if (xSSimpleType != null) {
            return iDValue.isDuplicateOf(this.fValidator, this.fValue, iDValue.fValue);
        }
        return this.fValue.equals(iDValue.fValue);
    }

    private boolean isDuplicateOf(XSSimpleType xSSimpleType, String string, String string2) {
        try {
            Object object = xSSimpleType.validate(string, VS, null);
            Object object2 = xSSimpleType.validate(string2, VS, null);
            return xSSimpleType.isEqual(object, object2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return "ID Value:  " + this.fValue;
    }

    static {
        VS.setExtraChecking(false);
        VS.setFacetChecking(false);
    }
}

