/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;

public class ResourceExists
extends ProjectComponent
implements Condition {
    private Resource resource;
    private String refid;

    public void setResource(Resource r) {
        this.onlyOne();
        this.resource = r;
    }

    public void setRefid(String refid) {
        this.onlyOne();
        this.refid = refid;
    }

    public void add(Resource r) {
        this.setResource(r);
    }

    public boolean eval() {
        if (this.resource == null && this.refid == null) {
            throw new BuildException("You must specify a resource.");
        }
        Resource r = this.resource != null ? this.resource : this.expandRefId();
        this.log("Checking: " + r, 3);
        return r.isExists();
    }

    private void onlyOne() {
        if (this.resource != null || this.refid != null) {
            throw new BuildException("Only one resource can be tested.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Resource expandRefId() {
        if (this.getProject() == null) {
            throw new BuildException("Cannot retrieve refid; project unset");
        }
        Object o = this.getProject().getReference(this.refid);
        if (o instanceof Resource) return (Resource)o;
        if (!(o instanceof ResourceCollection)) throw new BuildException("'" + this.refid + "' is not a resource but " + String.valueOf(o));
        ResourceCollection rc = (ResourceCollection)o;
        if (rc.size() != 1) throw new BuildException("Referred resource collection must contain exactly one resource.");
        o = rc.iterator().next();
        return (Resource)o;
    }
}

