/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.avalon.excalibur.io.IOUtil;

public final class FileUtil {
    public static File toFile(URL url) {
        if (!url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        return new File(filename);
    }

    public static String removeExtention(String filename) {
        return FileUtil.removeExtension(filename);
    }

    public static String removeExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static String getExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String removePath(String filepath) {
        return FileUtil.removePath(filepath, File.separatorChar);
    }

    public static String removePath(String filepath, char fileSeparatorChar) {
        int index = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index) {
            return filepath;
        }
        return filepath.substring(index + 1);
    }

    public static String getPath(String filepath) {
        return FileUtil.getPath(filepath, File.separatorChar);
    }

    public static String getPath(String filepath, char fileSeparatorChar) {
        int index = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index) {
            return "";
        }
        return filepath.substring(0, index);
    }

    public static void copyFileToDirectory(String source, String destinationDirectory) throws IOException {
        FileUtil.copyFileToDirectory(new File(source), new File(destinationDirectory));
    }

    public static void copyFileToDirectory(File source, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtil.copyFile(source, new File(destinationDirectory, source.getName()));
    }

    public static void copyFile(File source, File destination) throws IOException {
        if (!source.exists()) {
            throw new IOException("File " + source + " does not exist");
        }
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            throw new IOException("Unable to open file " + destination + " for writing.");
        }
        FileInputStream input = new FileInputStream(source);
        FileOutputStream output = new FileOutputStream(destination);
        IOUtil.copy((InputStream)input, (OutputStream)output);
        IOUtil.shutdownStream(input);
        IOUtil.shutdownStream(output);
        if (source.length() != destination.length()) {
            throw new IOException("Failed to copy full contents from " + source + " to " + destination);
        }
    }

    public static void copyURLToFile(URL source, File destination) throws IOException {
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            throw new IOException("Unable to open file " + destination + " for writing.");
        }
        InputStream input = source.openStream();
        FileOutputStream output = new FileOutputStream(destination);
        IOUtil.copy(input, (OutputStream)output);
        IOUtil.shutdownStream(input);
        IOUtil.shutdownStream(output);
    }

    public static String normalize(String path) {
        int index;
        String normalized = path;
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public static String catPath(String lookupPath, String path) {
        int index = lookupPath.lastIndexOf("/");
        String lookup = lookupPath.substring(0, index);
        String pth = path;
        while (pth.startsWith("../")) {
            if (lookup.length() <= 0) {
                return null;
            }
            index = lookup.lastIndexOf("/");
            lookup = lookup.substring(0, index);
            index = pth.indexOf("../") + 3;
            pth = pth.substring(index);
        }
        return lookup + "/" + pth;
    }

    public static File resolveFile(File baseFile, String filename) {
        String filenm = null;
        if ('/' != File.separatorChar) {
            filenm = filename.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            filenm = filename.replace('\\', File.separatorChar);
        }
        if (filenm.startsWith(File.separator)) {
            File file = new File(filenm);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return file;
        }
        char[] chars = filename.toCharArray();
        StringBuffer sb = new StringBuffer();
        int start = 0;
        if ('\\' == File.separatorChar) {
            sb.append(filenm.charAt(0));
            ++start;
        }
        int i = start;
        while (i < chars.length) {
            boolean doubleSeparator;
            boolean bl = doubleSeparator = File.separatorChar == chars[i] && File.separatorChar == chars[i - 1];
            if (!doubleSeparator) {
                sb.append(chars[i]);
            }
            ++i;
        }
        filenm = sb.toString();
        File file = new File(baseFile, filenm).getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return file;
    }

    public static void forceDelete(String file) throws IOException {
        FileUtil.forceDelete(new File(file));
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDirectory(file);
        } else if (!file.delete()) {
            throw new IOException("File " + file + " unable to be deleted.");
        }
    }

    public static void deleteDirectory(String directory) throws IOException {
        FileUtil.deleteDirectory(new File(directory));
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtil.cleanDirectory(directory);
        if (!directory.delete()) {
            throw new IOException("Directory " + directory + " unable to be deleted.");
        }
    }

    public static void cleanDirectory(String directory) throws IOException {
        FileUtil.cleanDirectory(new File(directory));
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            throw new IllegalArgumentException(directory + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory");
        }
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            FileUtil.forceDelete(file);
            ++i;
        }
    }

    private static String replaceSubString(String original, String oldString, String newString) {
        StringBuffer sb = new StringBuffer();
        int end = original.indexOf(oldString);
        int start = 0;
        int stringSize = oldString.length();
        while (end != -1) {
            sb.append(original.substring(start, end));
            sb.append(newString);
            start = end + stringSize;
            end = original.indexOf(oldString, start);
        }
        end = original.length();
        sb.append(original.substring(start, end));
        return sb.toString();
    }

    private FileUtil() {
    }
}

