/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.ReverseAxesWalker;
import org.w3c.dom.Node;

public class PrecedingWalker
extends ReverseAxesWalker {
    transient Node m_doc;

    public PrecedingWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public Node firstChild() {
        if (this.m_root.equals(this.m_currentNode)) {
            return null;
        }
        Node node = this.m_currentNode;
        while (node != null) {
            Node node2 = node.getFirstChild();
            if (node2 != null) {
                node = node2;
            } else if ((node = node.getNextSibling()) != null) {
                if (!this.m_root.equals(node) && this.isAncestorOfRootContext(node)) continue;
                return null;
            }
            if (node == null) continue;
            if (this.m_root.equals(node)) {
                return null;
            }
            if (!this.isAncestorOfRootContext(node)) break;
        }
        this.m_nextLevelAmount = node == null ? 0 : (node.hasChildNodes() ? 1 : 0);
        return this.setCurrentIfNotNull(node);
    }

    protected int getLevelMax() {
        return Short.MAX_VALUE;
    }

    public Node nextSibling() {
        if (this.m_root.equals(this.m_currentNode)) {
            return null;
        }
        Node node = this.m_currentNode.getNextSibling();
        if (node == null || this.m_root.equals(node)) {
            return null;
        }
        if (this.isAncestorOfRootContext(node) && ((node = node.getFirstChild()) == null || this.m_root.equals(node))) {
            return null;
        }
        this.m_nextLevelAmount = node == null ? 0 : (node.hasChildNodes() ? 1 : 0);
        return this.setCurrentIfNotNull(node);
    }

    public Node parentNode() {
        Node node = this.m_currentNode.getParentNode();
        if (node == null || this.m_doc.equals(node)) {
            return null;
        }
        if (this.isAncestorOfRootContext(node)) {
            return null;
        }
        this.m_nextLevelAmount = 0;
        return this.setCurrentIfNotNull(node);
    }

    public void resetProximityPositions() {
    }

    public void setRoot(Node node) {
        if (node.getNodeType() == 2) {
            node = this.m_lpi.getDOMHelper().getParentOfNode(node);
        }
        super.setRoot(node);
        this.m_currentNode = this.m_doc = this.m_lpi.getDOMHelper().getRootNode(node);
        this.m_nextLevelAmount = node.hasChildNodes() ? 1 : 0;
        super.resetProximityPositions();
    }
}

