/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tags;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Type;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Category;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.tags.AbstractProgramElementTagsHandler;
import xdoclet.tags.TypeTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.Log;

public class MethodTagsHandler
extends AbstractProgramElementTagsHandler {
    static /* synthetic */ Class class$xdoclet$tags$MethodTagsHandler;

    public static String getMethodTypeFor(MethodDoc method) throws XDocletException {
        return method.returnType().qualifiedTypeName() + method.returnType().dimension();
    }

    public static String getMethodNameWithoutPrefixFor(MethodDoc cur_method) {
        String str = cur_method.name();
        if (str.startsWith("get") || str.startsWith("set")) {
            return str.substring(3);
        }
        if (str.startsWith("is")) {
            return str.substring(2);
        }
        return str;
    }

    public static String getPropertyNameFor(MethodDoc method) {
        String name = MethodTagsHandler.getMethodNameWithoutPrefixFor(method);
        int len = name.length();
        if (len == 0) {
            return name;
        }
        if (len == 1) {
            return name.toLowerCase();
        }
        char c = name.charAt(0);
        if (c >= 'A' && c <= 'Z') {
            return (char)(c + 32) + name.substring(1);
        }
        return name;
    }

    public static boolean isGetter(String str) {
        return str.startsWith("get") || str.startsWith("is");
    }

    protected static boolean hasMethod(ClassDoc clazz, String methodName, String[] parameters, boolean setCurrentMethod) throws XDocletException {
        return AbstractProgramElementTagsHandler.hasExecutableMember(clazz, methodName, parameters, setCurrentMethod, 1);
    }

    public String getterPrefix() throws XDocletException {
        String prefix = "";
        if (XDocletTagSupport.getCurrentMethod().name().startsWith("get")) {
            prefix = "get";
        } else if (XDocletTagSupport.getCurrentMethod().name().startsWith("is")) {
            prefix = "is";
        } else if (XDocletTagSupport.getCurrentMethod().name().startsWith("set")) {
            String[] params = new String[]{XDocletTagSupport.getCurrentMethod().returnType().typeName()};
            if (MethodTagsHandler.hasMethod(XDocletTagSupport.getCurrentClass(), "is" + this.methodNameWithoutPrefix(), params, false)) {
                prefix = "is";
            } else {
                prefix = "get";
                return "get";
            }
        }
        return prefix;
    }

    public String getterMethod() throws XDocletException {
        return this.getterPrefix() + this.methodNameWithoutPrefix();
    }

    public String setterMethod() throws XDocletException {
        return "set" + this.methodNameWithoutPrefix();
    }

    public void setCurrentMethod(String template, Properties attributes) throws XDocletException {
        String methodName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
        }
        MethodDoc oldMethod = XDocletTagSupport.getCurrentMethod();
        if (MethodTagsHandler.hasMethod(XDocletTagSupport.getCurrentClass(), methodName, parameters, true)) {
            this.generate(template);
        }
        XDocletTagSupport.setCurrentMethod(oldMethod);
    }

    public String methodComment(Properties attributes) throws XDocletException {
        return this.memberComment(attributes, 1);
    }

    public String exceptionList(Properties attributes) throws XDocletException {
        return this.exceptionList(attributes, 1);
    }

    public void ifIsAbstract(String template, Properties attributes) throws XDocletException {
        if (this.isAbstract(attributes)) {
            this.generate(template);
        }
    }

    public void ifIsNotAbstract(String template, Properties attributes) throws XDocletException {
        if (!this.isAbstract(attributes)) {
            this.generate(template);
        }
    }

    public void forAllClassMethods(String template, Properties attributes) throws XDocletException {
        String type_name = attributes.getProperty("type");
        int extent = TypeTagsHandler.extractExtentType(attributes.getProperty("extent"));
        ClassDoc[] classes = AbstractProgramElementTagsHandler.getAllClasses();
        TreeSet<MethodDoc> methods = new TreeSet<MethodDoc>();
        int i = 0;
        while (i < classes.length) {
            if (type_name == null || TypeTagsHandler.isOfType((Type)classes[i], type_name, extent)) {
                MethodDoc[] classMethods = classes[i].methods();
                int j = 0;
                while (j < classMethods.length) {
                    methods.add(classMethods[j]);
                    ++j;
                }
            }
            ++i;
        }
        Iterator methodsIterator = methods.iterator();
        while (methodsIterator.hasNext()) {
            MethodDoc current = (MethodDoc)methodsIterator.next();
            XDocletTagSupport.setCurrentClass(current.containingClass());
            XDocletTagSupport.setCurrentMethod(current);
            this.generate(template);
        }
    }

    public void forAllMethods(String template, Properties attributes) throws XDocletException {
        this.forAllMembers(template, attributes, 1);
    }

    public void ifDoesntHaveMethodTag(String template, Properties attributes) throws XDocletException {
        if (!this.ifHasTag_Impl(template, attributes, 1)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void ifHasMethodTag(String template, Properties attributes) throws XDocletException {
        if (this.ifHasTag_Impl(template, attributes, 1)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void executeAndRestoreMethod(String template, Properties attributes) throws XDocletException {
        MethodDoc method = XDocletTagSupport.getCurrentMethod();
        this.generate(template);
        XDocletTagSupport.setCurrentMethod(method);
    }

    public void ifMethodTagValueEquals(String template, Properties attributes) throws XDocletException {
        if (this.ifTagValueEquals_Impl(template, attributes, 1)) {
            this.generate(template);
        }
    }

    public void ifMethodTagValueNotEquals(String template, Properties attributes) throws XDocletException {
        if (!this.ifTagValueEquals_Impl(template, attributes, 1)) {
            this.generate(template);
        }
    }

    public String methodTagValue(Properties attributes) throws XDocletException {
        return this.getTagValue(attributes, 1);
    }

    public void forAllMethodTags(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTags(template, attributes, 1, "only_call_method_not_null", new String[]{"forAllMethodTags"});
    }

    public void forAllMethodTagTokens(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTagTokens(template, attributes, 1);
    }

    public String firstSentenceDescriptionOfCurrentMethod() throws XDocletException {
        return XDocletTagSupport.getCurrentMethod().firstSentenceTags().length > 0 ? XDocletTagSupport.getCurrentMethod().firstSentenceTags()[0].text().trim() : "";
    }

    public String methodType() throws XDocletException {
        return MethodTagsHandler.getMethodTypeFor(XDocletTagSupport.getCurrentMethod());
    }

    public String methodName(Properties attributes) throws XDocletException {
        String value;
        if (attributes != null && (value = (String)((Hashtable)attributes).get("value")) != null) {
            String m = XDocletTagSupport.getCurrentMethod().name().substring(Integer.parseInt(value));
            char firstU = m.charAt(0);
            char firstL = Character.toLowerCase(firstU);
            return firstL + m.substring(1);
        }
        return XDocletTagSupport.getCurrentMethod() != null ? XDocletTagSupport.getCurrentMethod().name() : "";
    }

    public String methodNameWithoutPrefix() throws XDocletException {
        return MethodTagsHandler.getMethodNameWithoutPrefixFor(XDocletTagSupport.getCurrentMethod());
    }

    public String currentMethodName() throws XDocletException {
        return XDocletTagSupport.getCurrentMethod().name();
    }

    public String propertyName() throws XDocletException {
        return MethodTagsHandler.getPropertyNameFor(XDocletTagSupport.getCurrentMethod());
    }

    public void ifHasMethod(String template, Properties attributes) throws XDocletException {
        this.ifHasMethod_Impl(template, attributes, true);
    }

    public void ifDoesntHaveMethod(String template, Properties attributes) throws XDocletException {
        this.ifHasMethod_Impl(template, attributes, false);
    }

    private boolean isAbstract(Properties attributes) throws XDocletException {
        String method_name = attributes.getProperty("method");
        if (method_name == null) {
            return XDocletTagSupport.getCurrentMethod().isAbstract();
        }
        MethodDoc method_doc = (MethodDoc)this.getExecutableMemberDocForMemberName(method_name, false, 1);
        if (method_doc == null) {
            throw new Error("GRRR:");
        }
        return method_doc.isAbstract();
    }

    private void ifHasMethod_Impl(String template, Properties attributes, boolean has_method) throws XDocletException {
        Category cat = Log.getCategory(class$xdoclet$tags$MethodTagsHandler == null ? (class$xdoclet$tags$MethodTagsHandler = MethodTagsHandler.class$("xdoclet.tags.MethodTagsHandler")) : class$xdoclet$tags$MethodTagsHandler, "ifHasMethod_Impl");
        String methodName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("methodName=" + methodName));
            cat.debug((Object)("parametersStr=" + parametersStr));
            cat.debug((Object)("delimiter=" + delimiter));
            cat.debug((Object)("has_method=" + has_method));
            cat.debug((Object)("getCurrentClass()=" + XDocletTagSupport.getCurrentClass()));
        }
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
            if (cat.isDebugEnabled()) {
                cat.debug((Object)("parameters.length=" + parameters.length));
                cat.debug((Object)("parameters[0]=" + parameters[0]));
            }
        }
        if (MethodTagsHandler.hasMethod(XDocletTagSupport.getCurrentClass(), methodName, parameters, false) == has_method) {
            if (cat.isDebugEnabled()) {
                cat.debug((Object)"method found.");
            }
            this.generate(template);
        } else if (cat.isDebugEnabled()) {
            cat.debug((Object)"method not found.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

