/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.testcase;

import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.excalibur.logger.DefaultLogKitManager;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.io.StreamTarget;

public class ExcaliburTestCase
extends TestCase {
    private static final String FORMAT = "%7.7{priority} %5.5{time}   [%8.8{category}] (%{context}): %{message}\\n%{throwable}";
    private Logger m_logger;
    private ExcaliburComponentManager m_manager;
    protected Priority m_logPriority = Priority.DEBUG;
    protected ComponentManager manager;

    public void setUp() throws Exception {
        super.setUp();
        this.initialize();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.dispose();
    }

    protected Logger getLogger() {
        return this.m_logger;
    }

    protected void initialize() throws Exception {
        String resourceName = ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".xtest";
        System.out.println("ResourceName = " + resourceName);
        this.initialize(((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName).openStream());
    }

    protected final void initialize(InputStream testconf) throws Exception {
        this.m_logger = this.setupLogger();
        this.m_logger.debug("ExcaliburTestCase.initialize");
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        Configuration conf = builder.build(testconf);
        Context context = this.setupContext(conf.getChild("context"));
        this.m_manager = this.setupComponentManager(conf.getChild("components"), conf.getChild("roles"), conf.getChild("logkit"), context);
        this.manager = this.m_manager;
    }

    private final void dispose() {
        this.m_manager.dispose();
        this.m_manager = null;
    }

    private final Logger setupLogger() throws Exception {
        Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(this.getName());
        logger.setPriority(this.m_logPriority);
        PatternFormatter formatter = new PatternFormatter(FORMAT);
        StreamTarget target = new StreamTarget((OutputStream)System.out, (Formatter)formatter);
        logger.setLogTargets(new LogTarget[]{target});
        return logger;
    }

    private final Context setupContext(Configuration conf) throws Exception {
        DefaultContext context = new DefaultContext();
        Configuration[] confs = conf.getChildren("entry");
        int i = 0;
        while (i < confs.length) {
            String key = confs[i].getAttribute("name");
            String value = confs[i].getAttribute("value", null);
            if (value == null) {
                String clazz = confs[i].getAttribute("class");
                Object obj = ((Object)((Object)this)).getClass().getClassLoader().loadClass(clazz).newInstance();
                context.put((Object)key, obj);
                this.getLogger().info("ExcaliburTestCase: added an instance of class " + clazz + " to context entry " + key);
            } else {
                context.put((Object)key, (Object)value);
                this.getLogger().info("ExcaliburTestCase: added value \"" + value + "\" to context entry " + key);
            }
            ++i;
        }
        this.addContext(context);
        return context;
    }

    protected void addContext(DefaultContext context) {
    }

    private final ExcaliburComponentManager setupComponentManager(Configuration confCM, Configuration confRM, Configuration confLM, Context context) throws Exception {
        DefaultRoleManager roleManager = new DefaultRoleManager();
        roleManager.setLogger(this.m_logger);
        roleManager.configure(confRM);
        DefaultLogKitManager logKitManager = new DefaultLogKitManager();
        logKitManager.setLogger(this.m_logger);
        logKitManager.contextualize(context);
        logKitManager.configure(confLM);
        ExcaliburComponentManager manager = new ExcaliburComponentManager();
        manager.setLogger(this.m_logger);
        manager.setRoleManager(roleManager);
        manager.contextualize(context);
        manager.setLogKitManager(logKitManager);
        manager.configure(confCM);
        manager.initialize();
        return manager;
    }

    public ExcaliburTestCase(String name) {
        super(name);
    }
}

