/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipException;
import org.apache.avalon.excalibur.zip.ZipEntry;
import org.apache.avalon.excalibur.zip.ZipLong;
import org.apache.avalon.excalibur.zip.ZipShort;

public class ZipOutputStream
extends DeflaterOutputStream {
    private static final byte[] ZERO = new byte[]{0, 0};
    private static final byte[] LZERO = new byte[]{0, 0, 0, 0};
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    protected static final ZipLong LFH_SIG = new ZipLong(67324752L);
    protected static final ZipLong DD_SIG = new ZipLong(134695760L);
    protected static final ZipLong CFH_SIG = new ZipLong(33639248L);
    protected static final ZipLong EOCD_SIG = new ZipLong(101010256L);
    private static final ZipLong DOS_TIME_MIN = new ZipLong(8448L);
    private String comment = "";
    private int level = -1;
    private int method = 8;
    private ArrayList entries = new ArrayList();
    private CRC32 crc = new CRC32();
    private long written = 0L;
    private long dataStart = 0L;
    private ZipLong cdOffset = new ZipLong(0L);
    private ZipLong cdLength = new ZipLong(0L);
    private Hashtable offsets = new Hashtable();
    private String encoding = null;
    private ZipEntry entry;

    public ZipOutputStream(OutputStream out) {
        super(out, new Deflater(-1, true));
    }

    protected static ZipLong toDosTime(Date time) {
        int year = time.getYear() + 1900;
        int month = time.getMonth() + 1;
        if (year < 1980) {
            return DOS_TIME_MIN;
        }
        long value = year - 1980 << 25 | month << 21 | time.getDate() << 16 | time.getHours() << 11 | time.getMinutes() << 5 | time.getSeconds() >> 1;
        byte[] result = new byte[]{(byte)(value & 0xFFL), (byte)((value & 0xFF00L) >> 8), (byte)((value & 0xFF0000L) >> 16), (byte)((value & 0xFF000000L) >> 24)};
        return new ZipLong(result);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void closeEntry() throws IOException {
        if (this.entry == null) {
            return;
        }
        long realCrc = this.crc.getValue();
        this.crc.reset();
        if (this.entry.getMethod() == 8) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
            this.entry.setSize(this.def.getTotalIn());
            this.entry.setComprSize(this.def.getTotalOut());
            this.entry.setCrc(realCrc);
            this.def.reset();
            this.written += this.entry.getCompressedSize();
        } else {
            if (this.entry.getCrc() != realCrc) {
                throw new ZipException("bad CRC checksum for entry " + this.entry.getName() + ": " + Long.toHexString(this.entry.getCrc()) + " instead of " + Long.toHexString(realCrc));
            }
            if (this.entry.getSize() != this.written - this.dataStart) {
                throw new ZipException("bad size for entry " + this.entry.getName() + ": " + this.entry.getSize() + " instead of " + (this.written - this.dataStart));
            }
        }
        this.writeDataDescriptor(this.entry);
        this.entry = null;
    }

    public void finish() throws IOException {
        this.closeEntry();
        this.cdOffset = new ZipLong(this.written);
        int size = this.entries.size();
        int i = 0;
        while (i < size) {
            ZipEntry entry = (ZipEntry)this.entries.get(i);
            this.writeCentralFileHeader(entry);
            ++i;
        }
        this.cdLength = new ZipLong(this.written - this.cdOffset.getValue());
        this.writeCentralDirectoryEnd();
        this.offsets.clear();
        this.entries.clear();
    }

    public void putNextEntry(ZipEntry ze) throws IOException {
        this.closeEntry();
        this.entry = ze;
        this.entries.add(this.entry);
        if (this.entry.getMethod() == -1) {
            this.entry.setMethod(this.method);
        }
        if (this.entry.getTime() == -1L) {
            this.entry.setTime(System.currentTimeMillis());
        }
        if (this.entry.getMethod() == 0) {
            if (this.entry.getSize() == -1L) {
                throw new ZipException("uncompressed size is required for STORED method");
            }
            if (this.entry.getCrc() == -1L) {
                throw new ZipException("crc checksum is required for STORED method");
            }
            this.entry.setComprSize(this.entry.getSize());
        } else {
            this.def.setLevel(this.level);
        }
        this.writeLocalFileHeader(this.entry);
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        if (this.entry.getMethod() == 8) {
            super.write(b, offset, length);
        } else {
            this.out.write(b, offset, length);
            this.written += (long)length;
        }
        this.crc.update(b, offset, length);
    }

    protected byte[] getBytes(String name) throws ZipException {
        if (this.encoding == null) {
            return name.getBytes();
        }
        try {
            return name.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ZipException(uee.getMessage());
        }
    }

    protected void writeCentralDirectoryEnd() throws IOException {
        this.out.write(EOCD_SIG.getBytes());
        this.out.write(ZERO);
        this.out.write(ZERO);
        byte[] num = new ZipShort(this.entries.size()).getBytes();
        this.out.write(num);
        this.out.write(num);
        this.out.write(this.cdLength.getBytes());
        this.out.write(this.cdOffset.getBytes());
        byte[] data = this.getBytes(this.comment);
        this.out.write(new ZipShort(data.length).getBytes());
        this.out.write(data);
    }

    protected void writeCentralFileHeader(ZipEntry ze) throws IOException {
        this.out.write(CFH_SIG.getBytes());
        this.written += 4L;
        this.out.write(new ZipShort(20).getBytes());
        this.written += 2L;
        if (ze.getMethod() == 8) {
            this.out.write(new ZipShort(20).getBytes());
            this.out.write(new ZipShort(8).getBytes());
        } else {
            this.out.write(new ZipShort(10).getBytes());
            this.out.write(ZERO);
        }
        this.written += 4L;
        this.out.write(new ZipShort(ze.getMethod()).getBytes());
        this.written += 2L;
        this.out.write(ZipOutputStream.toDosTime(new Date(ze.getTime())).getBytes());
        this.written += 4L;
        this.out.write(new ZipLong(ze.getCrc()).getBytes());
        this.out.write(new ZipLong(ze.getCompressedSize()).getBytes());
        this.out.write(new ZipLong(ze.getSize()).getBytes());
        this.written += 12L;
        byte[] name = this.getBytes(ze.getName());
        this.out.write(new ZipShort(name.length).getBytes());
        this.written += 2L;
        byte[] extra = ze.getCentralDirectoryExtra();
        this.out.write(new ZipShort(extra.length).getBytes());
        this.written += 2L;
        String comm = ze.getComment();
        if (comm == null) {
            comm = "";
        }
        byte[] comment = this.getBytes(comm);
        this.out.write(new ZipShort(comment.length).getBytes());
        this.written += 2L;
        this.out.write(ZERO);
        this.written += 2L;
        this.out.write(new ZipShort(ze.getInternalAttributes()).getBytes());
        this.written += 2L;
        this.out.write(new ZipLong(ze.getExternalAttributes()).getBytes());
        this.written += 4L;
        this.out.write(((ZipLong)this.offsets.get(ze)).getBytes());
        this.written += 4L;
        this.out.write(name);
        this.written += (long)name.length;
        this.out.write(extra);
        this.written += (long)extra.length;
        this.out.write(comment);
        this.written += (long)comment.length;
    }

    protected void writeDataDescriptor(ZipEntry ze) throws IOException {
        if (ze.getMethod() != 8) {
            return;
        }
        this.out.write(DD_SIG.getBytes());
        this.out.write(new ZipLong(this.entry.getCrc()).getBytes());
        this.out.write(new ZipLong(this.entry.getCompressedSize()).getBytes());
        this.out.write(new ZipLong(this.entry.getSize()).getBytes());
        this.written += 16L;
    }

    protected void writeLocalFileHeader(ZipEntry ze) throws IOException {
        this.offsets.put(ze, new ZipLong(this.written));
        this.out.write(LFH_SIG.getBytes());
        this.written += 4L;
        if (ze.getMethod() == 8) {
            this.out.write(new ZipShort(20).getBytes());
            this.out.write(new ZipShort(8).getBytes());
        } else {
            this.out.write(new ZipShort(10).getBytes());
            this.out.write(ZERO);
        }
        this.written += 4L;
        this.out.write(new ZipShort(ze.getMethod()).getBytes());
        this.written += 2L;
        this.out.write(ZipOutputStream.toDosTime(new Date(ze.getTime())).getBytes());
        this.written += 4L;
        if (ze.getMethod() == 8) {
            this.out.write(LZERO);
            this.out.write(LZERO);
            this.out.write(LZERO);
        } else {
            this.out.write(new ZipLong(ze.getCrc()).getBytes());
            this.out.write(new ZipLong(ze.getSize()).getBytes());
            this.out.write(new ZipLong(ze.getSize()).getBytes());
        }
        this.written += 12L;
        byte[] name = this.getBytes(ze.getName());
        this.out.write(new ZipShort(name.length).getBytes());
        this.written += 2L;
        byte[] extra = ze.getLocalFileDataExtra();
        this.out.write(new ZipShort(extra.length).getBytes());
        this.written += 2L;
        this.out.write(name);
        this.written += (long)name.length;
        this.out.write(extra);
        this.written += (long)extra.length;
        this.dataStart = this.written;
    }
}

