/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;

public class BooleanFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() == 1) {
            return BooleanFunction.evaluate(args.get(0));
        }
        throw new FunctionCallException("boolean() requires one argument");
    }

    public static Boolean evaluate(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            if (((Number)obj).doubleValue() == Double.NaN || ((Number)obj).doubleValue() == 0.0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (obj instanceof String) {
            return ((String)obj).length() > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (obj instanceof List) {
            return ((List)obj).isEmpty() ? Boolean.FALSE : Boolean.TRUE;
        }
        if (obj instanceof Iterator) {
            return ((Iterator)obj).hasNext() ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }
}

