/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.i18n.util;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ResourceCheck {
    protected static Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor("XMLResourceBundle");
    private HashMap defaultPaths = new HashMap();
    private HashMap comparePaths = new HashMap();
    private Vector defaultPathOrder = new Vector();
    private Vector comparePathOrder = new Vector();
    private String bundleName = "";

    public static void main(String[] args) throws Exception {
        if (args.length >= 3) {
            ResourceCheck.main(args[0], args[1], args[2]);
        } else {
            StringBuffer usage = new StringBuffer(20);
            usage.append("XMLResourceBundle resource checker.\n");
            usage.append("Usage example:\n");
            usage.append("\t arguments \"\\resources en lv\" will take ");
            usage.append("\"\\resources\" path \n\t as the root path for all resource ");
            usage.append("files and will compare \n\t resources.xml in \\resources\\en ");
            usage.append("to resources.xml \n\t in \\resources\\lv.\n");
            System.out.print(usage.toString());
        }
    }

    public static void main(String resPath, String baseLang, String compareLang) throws Exception {
        String[] resourceNames = ResourceCheck.getResourceFilenames(resPath, baseLang);
        SAXBuilder builder = new SAXBuilder(false);
        if (logger.isInfoEnabled()) {
            logger.info("Comparing " + baseLang + " to " + compareLang + ":");
        }
        int i = 0;
        while (i < resourceNames.length) {
            String resourceName = resourceNames[i];
            if (logger.isInfoEnabled()) {
                logger.info("Bundle: " + resourceName);
            }
            String baseName = ResourceCheck.getResourceFilename(resPath, resourceName, baseLang);
            String compareName = ResourceCheck.getResourceFilename(resPath, resourceName, compareLang);
            ResourceCheck rc = new ResourceCheck(resourceName);
            Document doc = builder.build(new File(baseName));
            rc.readBaseElement("", doc.getRootElement(), false);
            File compareFile = new File(compareName);
            Element rootElement = null;
            if (compareFile.exists()) {
                doc = builder.build(compareFile);
                rootElement = doc.getRootElement();
            }
            rc.readCompareElement("", rootElement, false);
            rc.printMissingKeys();
            rc.printExtraKeys();
            ++i;
        }
    }

    private static String[] getResourceFilenames(String rootPath, String language) {
        LinkedList listResult = ResourceCheck.getResourceFilenames(rootPath, language, "", ".xml");
        String[] result = new String[listResult.size()];
        listResult.toArray(result);
        return result;
    }

    private static LinkedList getResourceFilenames(String rootPath, String language, String relativePath, String extension) {
        LinkedList<String> result;
        File file = new File(rootPath + File.separatorChar + language + File.separatorChar + relativePath);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            result = new LinkedList();
            int i = 0;
            while (i < files.length) {
                result.addAll(ResourceCheck.getResourceFilenames(rootPath, language, relativePath + File.separatorChar + files[i].getName(), extension));
                ++i;
            }
        } else {
            result = new LinkedList<String>();
            String fileName = relativePath;
            if (fileName.endsWith(extension)) {
                fileName = fileName.substring(0, fileName.length() - extension.length());
                if (logger.isDebugEnabled()) {
                    logger.debug("Found bundle: " + fileName);
                }
                result.add(fileName);
            }
        }
        return result;
    }

    private static String getResourceFilename(String rootPath, String resourceName, String language) {
        return rootPath + File.separator + language + File.separator + resourceName + ".xml";
    }

    public ResourceCheck(String bundleName) {
        this.bundleName = bundleName;
    }

    private void readBaseElement(String parentPath, Element e, boolean addAttributes) {
        String path = ResourceCheck.getPath(parentPath, e, addAttributes);
        List list = e.getChildren();
        if (list.size() == 0) {
            this.defaultPaths.put(path, new Boolean(false));
            this.defaultPathOrder.add(path);
        } else {
            int i = 0;
            while (i < list.size()) {
                this.readBaseElement(path, (Element)list.get(i), true);
                ++i;
            }
        }
    }

    private void readCompareElement(String parentPath, Element e, boolean addAttributes) {
        if (e == null) {
            logger.error(this.bundleName + ", bundle not found!");
            return;
        }
        String path = ResourceCheck.getPath(parentPath, e, addAttributes);
        List list = e.getChildren();
        if (list.size() == 0) {
            Boolean value = (Boolean)this.defaultPaths.get(path);
            this.comparePathOrder.add(path);
            if (value != null) {
                this.defaultPaths.put(path, new Boolean(true));
                this.comparePaths.put(path, new Boolean(true));
            } else {
                this.comparePaths.put(path, new Boolean(false));
            }
        } else {
            int i = 0;
            while (i < list.size()) {
                this.readCompareElement(path, (Element)list.get(i), true);
                ++i;
            }
        }
    }

    private static String getPath(String parentPath, Element e, boolean addAttributes) {
        StringBuffer sb = new StringBuffer(parentPath);
        sb.append('/');
        sb.append(e.getName());
        List list = e.getAttributes();
        if (list.size() > 0 && addAttributes) {
            sb.append("[");
            int i = 0;
            while (i < list.size()) {
                Attribute a = (Attribute)list.get(i);
                sb.append("@").append(a.getName()).append("='").append(a.getValue()).append("'");
                if (i < list.size() - 1) {
                    sb.append(" and ");
                }
                ++i;
            }
            sb.append("]");
        }
        return sb.toString();
    }

    private void printMissingKeys() {
        Enumeration keys = this.defaultPathOrder.elements();
        while (keys.hasMoreElements()) {
            String keyName = (String)keys.nextElement();
            Boolean value = (Boolean)this.defaultPaths.get(keyName);
            if (value.booleanValue()) continue;
            logger.error(this.bundleName + ", add: " + keyName);
        }
    }

    private void printExtraKeys() {
        Enumeration keys = this.comparePathOrder.elements();
        while (keys.hasMoreElements()) {
            String keyName = (String)keys.nextElement();
            Boolean value = (Boolean)this.comparePaths.get(keyName);
            if (value.booleanValue()) continue;
            logger.warn(this.bundleName + ", del: " + keyName);
        }
    }
}

