/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class SystemPath
extends DataType {
    public static final String SYSTEM_LOADER_REF = "ant.system.loader";

    public void setPathRef(Reference pathRef) throws BuildException {
        Path path = (Path)pathRef.getReferencedObject(this.project);
        this.initSystemLoader(path);
    }

    private final void initSystemLoader(Path path) {
        try {
            if (this.project.getReference(SYSTEM_LOADER_REF) != null) {
                return;
            }
            AntClassLoader acl = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), true);
            acl.addLoaderPackageRoot("org.apache.tools.ant.taskdefs.optional");
            this.project.addReference(SYSTEM_LOADER_REF, (Object)acl);
            String[] list = path.list();
            int i = 0;
            while (i < list.length) {
                File f = new File(list[i]);
                if (f.exists()) {
                    acl.addPathElement(f.getAbsolutePath());
                }
                ++i;
            }
            String antHome = this.project.getProperty("ant.home");
            File optionalJar = new File(antHome + "/lib/optional.jar");
            if (optionalJar.exists()) {
                acl.addPathElement(optionalJar.getAbsolutePath());
            }
            Hashtable tasks = this.project.getTaskDefinitions();
            String defs = "/org/apache/tools/ant/taskdefs/defaults.properties";
            try {
                Properties props = new Properties();
                InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(defs);
                if (in == null) {
                    throw new BuildException("Can't load default task list");
                }
                props.load(in);
                in.close();
                Enumeration<?> enumeration = props.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    String value = props.getProperty(key);
                    if (!value.startsWith("org.apache.tools.ant.taskdefs.optional")) continue;
                    try {
                        Class taskClass = acl.loadClass(value);
                        this.project.addTaskDefinition(key, taskClass);
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        this.log("Could not load a dependent class (" + ncdfe.getMessage() + ") for task " + key, 4);
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.log("Could not load class (" + value + ") for task " + key, 4);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (IOException ioe) {
                throw new BuildException("Can't load default task list");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

