/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Stack;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.ReverseAxesWalker;
import org.w3c.dom.Node;

public class AncestorWalker
extends ReverseAxesWalker {
    protected transient Stack m_ancestors;
    protected transient int m_ancestorsPos;

    public AncestorWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public Object clone() throws CloneNotSupportedException {
        AncestorWalker ancestorWalker = (AncestorWalker)super.clone();
        return ancestorWalker;
    }

    public Node firstChild() {
        Node node = this.m_ancestorsPos < 0 ? null : (Node)this.m_ancestors.elementAt(this.m_ancestorsPos--);
        this.m_nextLevelAmount = this.m_ancestorsPos < 0 ? 0 : 1;
        return this.setCurrentIfNotNull(node);
    }

    protected int getLevelMax() {
        DOMHelper dOMHelper = this.m_lpi.getDOMHelper();
        Node node = dOMHelper.getParentOfNode(this.m_root);
        return node == null ? 1 : (int)dOMHelper.getLevel(node);
    }

    protected void pushAncestors(Node node) {
        this.m_ancestors = new Stack();
        DOMHelper dOMHelper = this.m_lpi.getDOMHelper();
        while ((node = dOMHelper.getParentOfNode(node)) != null) {
            this.m_ancestors.push(node);
        }
        this.m_nextLevelAmount = this.m_ancestors.isEmpty() ? 0 : 1;
        this.m_ancestorsPos = this.m_ancestors.size() - 1;
    }

    public void setRoot(Node node) {
        this.pushAncestors(node);
        super.setRoot(node);
    }
}

