/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.util.EmptyStackException;
import java.util.Stack;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TemplatesHandler;
import org.apache.xalan.processor.ProcessorStylesheetElement;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.processor.XSLTElementDef;
import org.apache.xalan.processor.XSLTElementProcessor;
import org.apache.xalan.processor.XSLTSchema;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.FuncDocument;
import org.apache.xalan.templates.FuncFormatNumb;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.NodeConsumer;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xpath.XPath;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.functions.Function2Args;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class StylesheetHandler
extends DefaultHandler
implements TemplatesHandler,
PrefixResolver,
NodeConsumer {
    private static boolean m_xpathFunctionsInited = false;
    private int m_stylesheetLevel = -1;
    private boolean m_parsingComplete = false;
    private Vector m_prefixMappings = new Vector();
    private boolean m_shouldProcess = true;
    private String m_fragmentIDString;
    private int m_elementID = 0;
    private int m_fragmentID = 0;
    private TransformerFactoryImpl m_stylesheetProcessor;
    static final int STYPE_ROOT = 1;
    static final int STYPE_INCLUDE = 2;
    static final int STYPE_IMPORT = 3;
    private int m_stylesheetType = 1;
    private Stack m_stylesheets = new Stack();
    StylesheetRoot m_stylesheetRoot;
    Stylesheet m_lastPoppedStylesheet;
    private Stack m_processors = new Stack();
    private XSLTSchema m_schema = new XSLTSchema();
    private Stack m_elems = new Stack();
    private int m_docOrderCount = 0;
    private static XSLMessages m_XSLMessages = new XSLMessages();
    Stack m_baseIdentifiers = new Stack();
    private Stack m_stylesheetLocatorStack = new Stack();
    private Stack m_importStack = new Stack();
    private boolean warnedAboutOldXSLTNamespace = false;
    Stack m_nsSupportStack = new Stack();
    private Node m_originatingNode;
    private BoolStack m_spacePreserveStack = new BoolStack();

    public StylesheetHandler(TransformerFactoryImpl transformerFactoryImpl) throws TransformerConfigurationException {
        this.init(transformerFactoryImpl);
    }

    private void assertion(boolean bl, String string) throws RuntimeException {
        if (!bl) {
            throw new RuntimeException(string);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
        XSLTElementDef xSLTElementDef = xSLTElementProcessor.getElemDef();
        if (xSLTElementDef.getType() != 2) {
            xSLTElementProcessor = xSLTElementDef.getProcessorFor(null, "text()");
        }
        if (xSLTElementProcessor == null) {
            if (!XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
                this.error("Non-whitespace text is not allowed in this position in the stylesheet!", null);
            }
        } else {
            xSLTElementProcessor.characters(this, cArray, n, n2);
        }
    }

    private void checkForFragmentID(Attributes attributes) {
        if (!this.m_shouldProcess && attributes != null && this.m_fragmentIDString != null) {
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string;
                String string2 = attributes.getType(n2);
                if (string2.equalsIgnoreCase("ID") && (string = attributes.getValue(n2)).equalsIgnoreCase(this.m_fragmentIDString)) {
                    this.m_shouldProcess = true;
                    this.m_fragmentID = this.m_elementID;
                }
                ++n2;
            }
        }
    }

    XPath createMatchPatternXPath(String string) throws TransformerException {
        ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
        return new XPath(string, this.getLocator(), this, 1, errorListener);
    }

    public XPath createXPath(String string) throws TransformerException {
        ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
        return new XPath(string, this.getLocator(), this, 0, errorListener);
    }

    public void endDocument() throws SAXException {
        try {
            if (this.getStylesheetRoot() != null) {
                if (this.m_stylesheetLevel == 0) {
                    this.getStylesheetRoot().recompose();
                }
            } else {
                throw new TransformerException("Did not find the stylesheet root!");
            }
            XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
            if (xSLTElementProcessor != null) {
                xSLTElementProcessor.startNonText(this);
            }
            --this.m_stylesheetLevel;
            this.popSpaceHandling();
            this.m_parsingComplete = this.m_stylesheetLevel < 0;
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.m_elementID;
        if (!this.m_shouldProcess) {
            return;
        }
        if (this.m_elementID + 1 == this.m_fragmentID) {
            this.m_shouldProcess = false;
        }
        this.flushCharacters();
        this.popSpaceHandling();
        XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
        xSLTElementProcessor.endElement(this, string, string2, string3);
        this.popProcessor();
        this.getNamespaceSupport().popContext();
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    protected void error(int n, Object[] objectArray, Exception exception) throws SAXException {
        String string = XSLMessages.createMessage(n, objectArray);
        this.error(string, exception);
    }

    protected void error(String string, Exception exception) throws SAXException {
        SAXSourceLocator sAXSourceLocator = this.getLocator();
        ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
        TransformerException transformerException = !(exception instanceof TransformerException) ? (exception == null ? new TransformerException(string, sAXSourceLocator) : new TransformerException(string, sAXSourceLocator, exception)) : (TransformerException)exception;
        if (errorListener != null) {
            try {
                errorListener.error(transformerException);
            }
            catch (TransformerException transformerException2) {
                throw new SAXException(transformerException2);
            }
        } else {
            throw new SAXException(transformerException);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        String string = sAXParseException.getMessage();
        SAXSourceLocator sAXSourceLocator = this.getLocator();
        ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
        try {
            errorListener.error(new TransformerException(string, sAXSourceLocator));
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        String string = sAXParseException.getMessage();
        SAXSourceLocator sAXSourceLocator = this.getLocator();
        ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
        try {
            errorListener.fatalError(new TransformerException(string, sAXSourceLocator));
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    private void flushCharacters() throws SAXException {
        XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
        if (xSLTElementProcessor != null) {
            xSLTElementProcessor.startNonText(this);
        }
    }

    public String getBaseIdentifier() {
        String string = this.m_baseIdentifiers.isEmpty() ? null : this.m_baseIdentifiers.peek();
        if (string == null) {
            SAXSourceLocator sAXSourceLocator = this.getLocator();
            string = sAXSourceLocator == null ? "" : sAXSourceLocator.getSystemId();
        }
        return string;
    }

    XSLTElementProcessor getCurrentProcessor() {
        return (XSLTElementProcessor)this.m_processors.peek();
    }

    ElemTemplateElement getElemTemplateElement() {
        try {
            return (ElemTemplateElement)this.m_elems.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    Stylesheet getLastPoppedStylesheet() {
        return this.m_lastPoppedStylesheet;
    }

    public SAXSourceLocator getLocator() {
        if (this.m_stylesheetLocatorStack.isEmpty()) {
            SAXSourceLocator sAXSourceLocator = new SAXSourceLocator();
            sAXSourceLocator.setSystemId(this.getStylesheetProcessor().getDOMsystemID());
            return sAXSourceLocator;
        }
        return (SAXSourceLocator)this.m_stylesheetLocatorStack.peek();
    }

    public String getNamespaceForPrefix(String string) {
        return this.getNamespaceSupport().getURI(string);
    }

    public String getNamespaceForPrefix(String string, Node node) {
        this.assertion(true, "can't process a context node in StylesheetHandler!");
        return null;
    }

    NamespaceSupport getNamespaceSupport() {
        return (NamespaceSupport)this.m_nsSupportStack.peek();
    }

    public Node getOriginatingNode() {
        return this.m_originatingNode;
    }

    XSLTElementProcessor getProcessorFor(String string, String string2, String string3) throws SAXException {
        XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
        XSLTElementDef xSLTElementDef = xSLTElementProcessor.getElemDef();
        XSLTElementProcessor xSLTElementProcessor2 = xSLTElementDef.getProcessorFor(string, string2);
        if (xSLTElementProcessor2 == null && (this.getStylesheet() == null || Double.valueOf(this.getStylesheet().getVersion()) > 1.0 || !string.equals("http://www.w3.org/1999/XSL/Transform") && xSLTElementProcessor instanceof ProcessorStylesheetElement)) {
            xSLTElementProcessor2 = xSLTElementDef.getProcessorForUnknown(string, string2);
        }
        if (xSLTElementProcessor2 == null) {
            this.error(String.valueOf(string3) + " is not allowed in this position in the stylesheet!", null);
        }
        return xSLTElementProcessor2;
    }

    XSLTSchema getSchema() {
        return this.m_schema;
    }

    Stylesheet getStylesheet() {
        return this.m_stylesheets.size() == 0 ? null : (Stylesheet)this.m_stylesheets.peek();
    }

    TransformerFactoryImpl getStylesheetProcessor() {
        return this.m_stylesheetProcessor;
    }

    public StylesheetRoot getStylesheetRoot() {
        return this.m_stylesheetRoot;
    }

    int getStylesheetType() {
        return this.m_stylesheetType;
    }

    public String getSystemId() {
        return this.getBaseIdentifier();
    }

    public Templates getTemplates() {
        return this.getStylesheetRoot();
    }

    XSLMessages getXSLMessages() {
        return m_XSLMessages;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        this.getCurrentProcessor().ignorableWhitespace(this, cArray, n, n2);
    }

    boolean importStackContains(String string) {
        return this.stackContains(this.m_importStack, string);
    }

    void init(TransformerFactoryImpl transformerFactoryImpl) {
        if (!m_xpathFunctionsInited) {
            StylesheetHandler stylesheetHandler = this;
            synchronized (stylesheetHandler) {
                if (!m_xpathFunctionsInited) {
                    m_xpathFunctionsInited = true;
                    Function2Args function2Args = new FuncDocument();
                    FunctionTable.installFunction("document", function2Args);
                    function2Args = new FuncFormatNumb();
                    FunctionTable.installFunction("format-number", function2Args);
                }
            }
        }
        this.m_stylesheetProcessor = transformerFactoryImpl;
        this.m_processors.push(this.m_schema.getElementProcessor());
        this.pushNewNamespaceSupport();
    }

    boolean isSpacePreserve() {
        return this.m_spacePreserveStack.peek();
    }

    public boolean isStylesheetParsingComplete() {
        return this.m_parsingComplete;
    }

    int nextUid() {
        return this.m_docOrderCount++;
    }

    public void notationDecl(String string, String string2, String string3) {
        this.getCurrentProcessor().notationDecl(this, string, string2, string3);
    }

    String popBaseIndentifier() {
        return (String)this.m_baseIdentifiers.pop();
    }

    ElemTemplateElement popElemTemplateElement() {
        return (ElemTemplateElement)this.m_elems.pop();
    }

    String popImportURL() {
        return (String)this.m_importStack.pop();
    }

    void popNamespaceSupport() {
        this.m_nsSupportStack.pop();
    }

    XSLTElementProcessor popProcessor() {
        return (XSLTElementProcessor)this.m_processors.pop();
    }

    void popSpaceHandling() {
        this.m_spacePreserveStack.pop();
    }

    Stylesheet popStylesheet() {
        if (!this.m_stylesheetLocatorStack.isEmpty()) {
            this.m_stylesheetLocatorStack.pop();
        }
        if (!this.m_stylesheets.isEmpty()) {
            this.m_lastPoppedStylesheet = (Stylesheet)this.m_stylesheets.pop();
        }
        return this.m_lastPoppedStylesheet;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        this.flushCharacters();
        this.getCurrentProcessor().processingInstruction(this, string, string2);
    }

    void pushBaseIndentifier(String string) {
        if (string != null) {
            int n = string.indexOf(35);
            if (n > -1) {
                this.m_fragmentIDString = string.substring(n + 1);
                this.m_shouldProcess = false;
            } else {
                this.m_shouldProcess = true;
            }
        } else {
            this.m_shouldProcess = true;
        }
        this.m_baseIdentifiers.push(string);
    }

    void pushElemTemplateElement(ElemTemplateElement elemTemplateElement) {
        if (elemTemplateElement.getUid() == -1) {
            elemTemplateElement.setUid(this.nextUid());
        }
        this.m_elems.push(elemTemplateElement);
    }

    void pushImportURL(String string) {
        this.m_importStack.push(string);
    }

    void pushNewNamespaceSupport() {
        this.m_nsSupportStack.push(new NamespaceSupport());
    }

    void pushProcessor(XSLTElementProcessor xSLTElementProcessor) {
        this.m_processors.push(xSLTElementProcessor);
    }

    void pushSpaceHandling(Attributes attributes) throws SAXParseException {
        String string = attributes.getValue("xml:space");
        if (string == null) {
            this.m_spacePreserveStack.push(this.m_spacePreserveStack.peek());
        } else if (string.equals("preserve")) {
            this.m_spacePreserveStack.push(true);
        } else if (string.equals("default")) {
            this.m_spacePreserveStack.push(false);
        } else {
            SAXSourceLocator sAXSourceLocator = this.getLocator();
            ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
            try {
                errorListener.error(new TransformerException("Illegal value for xml:space", sAXSourceLocator));
            }
            catch (TransformerException transformerException) {
                throw new SAXParseException(transformerException.getMessage(), sAXSourceLocator, transformerException);
            }
            this.m_spacePreserveStack.push(this.m_spacePreserveStack.peek());
        }
    }

    void pushSpaceHandling(boolean bl) throws SAXParseException {
        this.m_spacePreserveStack.push(bl);
    }

    public void pushStylesheet(Stylesheet stylesheet) {
        if (this.m_stylesheets.size() == 0) {
            this.m_stylesheetRoot = (StylesheetRoot)stylesheet;
        }
        this.m_stylesheets.push(stylesheet);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return this.getCurrentProcessor().resolveEntity(this, string, string2);
    }

    public void setDocumentLocator(Locator locator) {
        this.m_stylesheetLocatorStack.push(new SAXSourceLocator(locator));
    }

    public void setOriginatingNode(Node node) {
        this.m_originatingNode = node;
    }

    void setStylesheetType(int n) {
        this.m_stylesheetType = n;
    }

    public void setSystemId(String string) {
        this.pushBaseIndentifier(string);
    }

    public void skippedEntity(String string) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        this.getCurrentProcessor().skippedEntity(this, string);
    }

    private boolean stackContains(Stack stack, String string) {
        int n = stack.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)stack.elementAt(n2);
            if (string2.equals(string)) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public void startDocument() throws SAXException {
        ++this.m_stylesheetLevel;
        this.pushSpaceHandling(false);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        NamespaceSupport namespaceSupport = this.getNamespaceSupport();
        namespaceSupport.pushContext();
        int n = this.m_prefixMappings.size();
        int n2 = 0;
        while (n2 < n) {
            object = (String)this.m_prefixMappings.elementAt(n2++);
            String string4 = (String)this.m_prefixMappings.elementAt(n2);
            namespaceSupport.declarePrefix((String)object, string4);
            ++n2;
        }
        this.m_prefixMappings.removeAllElements();
        ++this.m_elementID;
        this.checkForFragmentID(attributes);
        if (!this.m_shouldProcess) {
            return;
        }
        this.flushCharacters();
        this.pushSpaceHandling(attributes);
        object = this.getProcessorFor(string, string2, string3);
        this.pushProcessor((XSLTElementProcessor)object);
        ((XSLTElementProcessor)object).startElement(this, string, string2, string3, attributes);
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.m_prefixMappings.addElement(string);
        this.m_prefixMappings.addElement(string2);
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        this.getCurrentProcessor().unparsedEntityDecl(this, string, string2, string3, string4);
    }

    public void warn(int n, Object[] objectArray) throws SAXException {
        String string = XSLMessages.createWarning(n, objectArray);
        SAXSourceLocator sAXSourceLocator = this.getLocator();
        ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
        try {
            if (errorListener != null) {
                errorListener.warning(new TransformerException(string, sAXSourceLocator));
            }
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        String string = sAXParseException.getMessage();
        SAXSourceLocator sAXSourceLocator = this.getLocator();
        ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
        try {
            errorListener.warning(new TransformerException(string, sAXSourceLocator));
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }
}

