/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.collections;

import org.apache.avalon.excalibur.collections.Buffer;
import org.apache.avalon.excalibur.collections.BufferOverflowException;
import org.apache.avalon.excalibur.collections.BufferUnderflowException;

public final class FixedSizeBuffer
implements Buffer {
    private final Object[] m_elements;
    private int m_start = 0;
    private int m_end = 0;

    public FixedSizeBuffer(int size) {
        this.m_elements = new Object[size + 1];
    }

    public FixedSizeBuffer() {
        this(32);
    }

    public final int size() {
        int size = 0;
        size = this.m_end < this.m_start ? this.m_elements.length - this.m_start + this.m_end : this.m_end - this.m_start;
        return size;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final void add(Object element) {
        if (this.size() > this.m_elements.length) {
            throw new BufferOverflowException("The buffer cannot hold more than " + this.m_elements.length + " objects.");
        }
        this.m_elements[this.m_end] = element;
        ++this.m_end;
        if (this.m_end >= this.m_elements.length) {
            this.m_end = 0;
        }
    }

    public final Object remove() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        Object element = this.m_elements[this.m_start];
        if (null != element) {
            this.m_elements[this.m_start] = null;
            ++this.m_start;
            if (this.m_start >= this.m_elements.length) {
                this.m_start = 0;
            }
        }
        return element;
    }
}

