/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;

public class Resources {
    private static final Random RANDOM = new Random();
    private final Locale m_locale;
    private ResourceBundle m_bundle;
    private String m_baseName;

    public String getString(String key, Object arg1) {
        Object[] args = new Object[]{arg1};
        return this.format(key, args);
    }

    public String getString(String key, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return this.format(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.format(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return this.format(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4, arg5};
        return this.format(key, args);
    }

    public String format(String key, Object[] args) {
        try {
            String pattern = this.getPatternString(key);
            return MessageFormat.format(pattern, args);
        }
        catch (MissingResourceException mre) {
            return "Unable to locate resource '" + this.m_baseName + "' with key '" + key + "' due to: " + mre;
        }
    }

    public String getString(String key) {
        try {
            ResourceBundle bundle = this.getBundle();
            return bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            return "Unable to locate resource '" + this.m_baseName + "' with key '" + key + "' due to: " + mre;
        }
    }

    public final ResourceBundle getBundle() throws MissingResourceException {
        if (this.m_bundle == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            this.m_bundle = classLoader != null ? ResourceBundle.getBundle(this.m_baseName, this.m_locale, classLoader) : ResourceBundle.getBundle(this.m_baseName, this.m_locale);
        }
        return this.m_bundle;
    }

    private String getPatternString(String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle();
        Object object = bundle.getObject(key);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof String[]) {
            String[] strings = (String[])object;
            return strings[RANDOM.nextInt(strings.length)];
        }
        throw new MissingResourceException("Unable to find resource of appropriate type.", "java.lang.String", key);
    }

    public Resources(String baseName) {
        this(baseName, Locale.getDefault());
    }

    public Resources(String baseName, Locale locale) {
        this.m_baseName = baseName;
        this.m_locale = locale;
    }
}

