/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.log.Hierarchy;
import org.apache.log.output.AbstractOutputTarget;

public class DatagramOutputTarget
extends AbstractOutputTarget {
    private DatagramSocket m_socket = new DatagramSocket();

    protected void output(String stringData) {
        byte[] data = stringData.getBytes();
        try {
            DatagramPacket packet = new DatagramPacket(data, data.length);
            this.m_socket.send(packet);
        }
        catch (IOException ioe) {
            Hierarchy.getDefaultHierarchy().log("Error sending datagram.", ioe);
        }
    }

    public DatagramOutputTarget(InetAddress address, int port) throws IOException {
        this.m_socket.connect(address, port);
    }
}

