/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.stree.Child;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.patterns.NodeTestFilter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public abstract class AxesWalker
extends PredicatedNodeTest
implements Cloneable,
TreeWalker,
NodeFilter {
    static final boolean DEBUG = false;
    static final boolean DEBUG_WAITING = false;
    static final boolean DEBUG_TRAVERSAL = false;
    static final boolean DEBUG_LOCATED = false;
    static boolean m_didDumpAll = false;
    public static final String FEATURE_NODETESTFILTER = "NodeTestFilter";
    transient Node m_root;
    transient Node m_currentNode;
    transient Node m_prevReturned;
    private int m_argLen;
    private int m_stepType;
    private transient boolean m_didSwitch = false;
    transient boolean m_isDone = false;
    transient boolean m_isFresh;
    protected transient int m_nextLevelAmount;
    protected AxesWalker m_nextWalker;
    AxesWalker m_prevWalker;

    public AxesWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    private final void addToWaitList(AxesWalker axesWalker) {
        this.m_lpi.addToWaitList(axesWalker);
    }

    public boolean canTraverseOutsideSubtree() {
        if (super.canTraverseOutsideSubtree()) {
            return true;
        }
        if (this.m_nextWalker != null) {
            return this.m_nextWalker.canTraverseOutsideSubtree();
        }
        return false;
    }

    AxesWalker checkNeedsToWait(AxesWalker axesWalker) {
        AxesWalker axesWalker2 = axesWalker.m_prevWalker;
        if (axesWalker2 != null && !this.checkOKToTraverse(axesWalker2, axesWalker, axesWalker.m_currentNode, axesWalker.m_nextLevelAmount)) {
            if (this.isWaiting(axesWalker)) {
                try {
                    this.addToWaitList((AxesWalker)axesWalker.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            } else {
                this.addToWaitList(axesWalker);
            }
            axesWalker = axesWalker.m_prevWalker;
        }
        return axesWalker;
    }

    protected boolean checkOKToTraverse(AxesWalker axesWalker, AxesWalker axesWalker2, Node node, int n) {
        short s;
        boolean bl;
        DOMHelper dOMHelper = this.m_lpi.getDOMHelper();
        short s2 = dOMHelper.getLevel(node);
        Node node2 = axesWalker.m_currentNode;
        boolean bl2 = !axesWalker.m_isDone && axesWalker.getLevelMax() > s2 ? ((bl = dOMHelper.isNodeAfter(node2, node) ^ true) ? (s = dOMHelper.getLevel(node2)) <= s2 + n : false) : true;
        return bl2;
    }

    AxesWalker checkWaiting(AxesWalker axesWalker) {
        if (axesWalker != null && axesWalker.m_currentNode == null) {
            return axesWalker;
        }
        int n = this.m_lpi.getWaitingCount();
        int n2 = this.m_lpi.m_waitingBottom;
        while (n2 < n) {
            AxesWalker axesWalker2 = this.m_lpi.getWaiting(n2);
            AxesWalker axesWalker3 = axesWalker2.m_prevWalker;
            if (axesWalker3 != null && this.checkOKToTraverse(axesWalker3, axesWalker2, axesWalker2.m_currentNode, axesWalker2.m_nextLevelAmount)) {
                AxesWalker axesWalker4;
                if (axesWalker != null && !this.isWaiting(axesWalker4 = axesWalker)) {
                    this.addToWaitList(axesWalker4);
                }
                axesWalker = axesWalker2;
                this.m_lpi.removeFromWaitList(axesWalker);
                axesWalker.printEntryDebug();
                this.m_didSwitch = true;
                break;
            }
            ++n2;
        }
        return axesWalker;
    }

    public Object clone() throws CloneNotSupportedException {
        AxesWalker axesWalker = (AxesWalker)super.clone();
        return axesWalker;
    }

    AxesWalker cloneDeep(LocPathIterator locPathIterator, Vector vector) throws CloneNotSupportedException {
        AxesWalker axesWalker = AxesWalker.findClone(this, vector);
        if (axesWalker != null) {
            return axesWalker;
        }
        axesWalker = (AxesWalker)this.clone();
        axesWalker.setLocPathIterator(locPathIterator);
        if (vector != null) {
            vector.addElement(this);
            vector.addElement(axesWalker);
        }
        if (this.m_lpi.m_lastUsedWalker == this) {
            locPathIterator.m_lastUsedWalker = axesWalker;
        }
        if (this.m_nextWalker != null) {
            axesWalker.m_nextWalker = this.m_nextWalker.cloneDeep(locPathIterator, vector);
        }
        if (vector != null) {
            if (this.m_prevWalker != null) {
                axesWalker.m_prevWalker = this.m_prevWalker.cloneDeep(locPathIterator, vector);
            }
        } else if (this.m_nextWalker != null) {
            axesWalker.m_nextWalker.m_prevWalker = axesWalker;
        }
        return axesWalker;
    }

    private void dumpAll(Node node, int n) {
        Object object;
        int n2 = 0;
        while (n2 < n) {
            System.out.print(" ");
            ++n2;
        }
        System.out.print(this.nodeToString(node));
        if (node.getNodeType() == 3 && (object = node.getNodeValue()) != null) {
            System.out.print("+= -->" + ((String)object).trim());
        }
        System.out.println("");
        object = node.getAttributes();
        if (object != null) {
            int n3 = object.getLength();
            int n4 = 0;
            while (n4 < n3) {
                int n5 = 0;
                while (n5 < n) {
                    System.out.print(" ");
                    ++n5;
                }
                System.out.print("attr -->");
                System.out.print(this.nodeToString(object.item(n4)));
                String string = object.item(n4).getNodeValue();
                if (string != null) {
                    System.out.print("+= -->" + string.trim());
                }
                System.out.println("");
                ++n4;
            }
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.dumpAll(node2, n + 1);
            node2 = node2.getNextSibling();
        }
    }

    static AxesWalker findClone(AxesWalker axesWalker, Vector vector) {
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                if (axesWalker == vector.elementAt(n2)) {
                    return (AxesWalker)vector.elementAt(n2 + 1);
                }
                n2 += 2;
            }
        }
        return null;
    }

    public Node firstChild() {
        return null;
    }

    protected int getArgLen() {
        return this.m_argLen;
    }

    public final Node getCurrentNode() {
        return this.m_currentNode;
    }

    private AxesWalker getEarliestWaiting() {
        DOMHelper dOMHelper = this.m_lpi.getDOMHelper();
        AxesWalker axesWalker = null;
        int n = this.m_lpi.getWaitingCount();
        int n2 = this.m_lpi.m_waitingBottom;
        while (n2 < n) {
            AxesWalker axesWalker2 = this.m_lpi.getWaiting(n2);
            if (axesWalker == null) {
                axesWalker = axesWalker2;
            } else if (!dOMHelper.isNodeAfter(axesWalker2.m_currentNode, axesWalker.m_currentNode)) {
                axesWalker = axesWalker2;
            }
            ++n2;
        }
        if (axesWalker != null) {
            this.m_lpi.removeFromWaitList(axesWalker);
            super.printEntryDebug();
        }
        return axesWalker;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public NodeFilter getFilter() {
        return this;
    }

    public int getLastPos(XPathContext xPathContext) {
        AxesWalker axesWalker;
        int n = this.getProximityPosition();
        try {
            axesWalker = (AxesWalker)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return -1;
        }
        axesWalker.setPredicateCount(axesWalker.getPredicateCount() - 1);
        axesWalker.setNextWalker(null);
        axesWalker.setPrevWalker(null);
        LocPathIterator locPathIterator = axesWalker.getLocPathIterator();
        AxesWalker axesWalker2 = locPathIterator.getLastUsedWalker();
        try {
            Node node;
            locPathIterator.setLastUsedWalker(axesWalker);
            while ((node = axesWalker.nextNode()) != null) {
                ++n;
            }
        }
        finally {
            Object var7_7 = null;
            locPathIterator.setLastUsedWalker(axesWalker2);
        }
        return n;
    }

    protected int getLevelMax() {
        return 0;
    }

    protected int getNextLevelAmount() {
        return this.m_nextLevelAmount;
    }

    protected Node getNextNode() {
        Node node;
        if (this.m_isFresh) {
            this.m_isFresh = false;
        }
        if ((node = this.getCurrentNode()).isSupported(FEATURE_NODETESTFILTER, "1.0")) {
            ((NodeTestFilter)((Object)node)).setNodeTest(this);
        }
        Node node2 = this.firstChild();
        while (node2 == null) {
            Node node3;
            node2 = this.nextSibling();
            if (node2 == null && (node3 = this.parentNode()) == null) break;
        }
        if (node2 == null) {
            this.m_isDone = true;
        }
        return node2;
    }

    public AxesWalker getNextWalker() {
        return this.m_nextWalker;
    }

    public AxesWalker getPrevWalker() {
        return this.m_prevWalker;
    }

    public Node getRoot() {
        return this.m_root;
    }

    protected int getStepType() {
        return this.m_stepType;
    }

    public void init(Compiler compiler, int n, int n2) throws TransformerException {
        this.m_stepType = n2;
        switch (n2) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.m_argLen = compiler.getArgLength(n);
                break;
            }
            default: {
                this.m_argLen = compiler.getArgLengthOfStep(n);
            }
        }
        this.initPredicateInfo(compiler, n);
    }

    boolean isAncestorOfRootContext(Node node) {
        Node node2 = this.m_root;
        while ((node2 = node2.getParentNode()) != null) {
            if (!node2.equals(node)) continue;
            return true;
        }
        return false;
    }

    protected boolean isFastWalker() {
        return false;
    }

    boolean isWaiting(AxesWalker axesWalker) {
        int n = this.m_lpi.getWaitingCount();
        int n2 = this.m_lpi.m_waitingBottom;
        while (n2 < n) {
            AxesWalker axesWalker2 = this.m_lpi.getWaiting(n2);
            if (axesWalker2 == axesWalker) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Node lastChild() {
        throw new RuntimeException("lastChild not supported!");
    }

    public Node nextNode() {
        Node node = null;
        AxesWalker axesWalker = this.m_lpi.getLastUsedWalker();
        this.m_didSwitch = false;
        boolean bl = true;
        while (true) {
            AxesWalker axesWalker2;
            if (bl) {
                axesWalker2 = this.checkWaiting(axesWalker);
                if (this.m_didSwitch) {
                    this.m_didSwitch = false;
                    axesWalker = axesWalker2;
                } else if (axesWalker != null && (axesWalker2 = this.checkNeedsToWait(axesWalker)) != axesWalker) {
                    axesWalker = axesWalker2;
                    continue;
                }
            } else {
                bl = true;
            }
            if (axesWalker != null) {
                node = axesWalker.getNextNode();
                if (node == null) {
                    axesWalker = axesWalker.m_prevWalker;
                    if (axesWalker != null) {
                        axesWalker.printEntryDebug();
                        continue;
                    }
                    axesWalker = this.getEarliestWaiting();
                    if (axesWalker == null) continue;
                    bl = false;
                    continue;
                }
                if (axesWalker.acceptNode(node) != 1) continue;
                if (axesWalker.m_nextWalker == null) {
                    this.m_lpi.setLastUsedWalker(axesWalker);
                } else {
                    axesWalker2 = axesWalker;
                    axesWalker = axesWalker.m_nextWalker;
                    if (this.isWaiting(axesWalker)) {
                        try {
                            axesWalker = (AxesWalker)axesWalker.clone();
                            axesWalker.setRoot(node);
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                    } else {
                        axesWalker.setRoot(node);
                    }
                    axesWalker.m_prevWalker = axesWalker2;
                    axesWalker.printEntryDebug();
                    continue;
                }
            }
            if (node == null || this.m_prevReturned == null || node.getOwnerDocument() != this.m_prevReturned.getOwnerDocument() || !this.m_lpi.getDOMHelper().isNodeAfter(node, this.m_prevReturned)) break;
        }
        this.m_prevReturned = node;
        return node;
    }

    public Node nextSibling() {
        return null;
    }

    public Node parentNode() {
        return null;
    }

    public Node previousNode() {
        throw new RuntimeException("previousNode not supported!");
    }

    public Node previousSibling() {
        throw new RuntimeException("previousSibling not supported!");
    }

    private void printDebug(String string) {
    }

    private void printDebugAdd(String string) {
    }

    private void printEntryDebug() {
    }

    private void printWaiters() {
    }

    private Node returnNextNode(Node node) {
        return node;
    }

    protected Node setCurrentIfNotNull(Node node) throws DOMException {
        if (node != null) {
            this.m_currentNode = node;
        }
        return node;
    }

    public void setCurrentNode(Node node) throws DOMException {
        this.m_currentNode = node;
    }

    public void setNextWalker(AxesWalker axesWalker) {
        this.m_nextWalker = axesWalker;
    }

    public void setPrevWalker(AxesWalker axesWalker) {
        this.m_prevWalker = axesWalker;
    }

    public void setRoot(Node node) {
        this.m_isFresh = true;
        this.m_isDone = false;
        this.m_root = node;
        this.m_currentNode = node;
        this.m_prevReturned = null;
        if (node == null) {
            throw new RuntimeException("\n !!!! Error! Setting the root of a walker to null!!!");
        }
        this.resetProximityPositions();
    }

    public String toString() {
        String string;
        String string2;
        Class<?> clazz = this.getClass();
        String string3 = clazz.getName();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        try {
            string2 = this.m_root == null ? "null" : String.valueOf(this.m_root.getNodeName()) + "{" + ((Child)this.m_root).getUid() + "}";
            string = this.m_root == null ? "null" : String.valueOf(this.m_currentNode.getNodeName()) + "{" + ((Child)this.m_currentNode).getUid() + "}";
        }
        catch (ClassCastException classCastException) {
            string2 = this.m_root == null ? "null" : this.m_root.getNodeName();
            string = this.m_root == null ? "null" : this.m_currentNode.getNodeName();
        }
        return String.valueOf(string3) + "[" + string2 + "][" + string + "]";
    }
}

