/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.activity.Suspendable;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.parameters.Parameterizable;

public final class ComponentUtil {
    public static final long LOG_ENABLED = 1L;
    public static final long CONTEXTUALIZED = 2L;
    public static final long PARAMETERIZED = 4L;
    public static final long CONFIGURED = 8L;
    public static final long COMPOSED = 16L;
    public static final long ACTIVE = 0x10000000L;
    public static final long INITIALIZED = 18L;
    public static final long STARTED = 20L;
    public static final long SUSPENDED = 0x1000000L;
    public static final long STOPPED = 24L;
    public static final long DISPOSED = 32L;
    public static final long INIT_MASK = 31L;

    public static final long createStateMask(Object obj) {
        long mask = 0L;
        if (obj instanceof LogEnabled || obj instanceof Loggable) {
            mask |= 1L;
        }
        if (obj instanceof Contextualizable) {
            mask |= 2L;
        }
        if (obj instanceof Parameterizable) {
            mask |= 4L;
        }
        if (obj instanceof Configurable) {
            mask |= 8L;
        }
        if (obj instanceof Composable) {
            mask |= 0x10L;
        }
        if (obj instanceof Initializable) {
            mask |= 0x12L;
        }
        if (obj instanceof Disposable) {
            mask |= 0x20L;
        }
        if (obj instanceof Startable) {
            mask |= 0x1CL;
        }
        if (obj instanceof Suspendable) {
            mask |= 0x1000000L;
        }
        return mask & 0xFFFFFFFFEFFFFFFFL;
    }

    public static final void setWriteOnceObject(Object source, Object value, String message) {
        if (source != null) {
            throw new IllegalStateException(message);
        }
        source = value;
    }

    public static final void checkLogEnabled(long state, long mask, String message) {
        if ((state & mask & 1L) > 0L || (mask & 1L) == 0L || state > 1L) {
            throw new IllegalStateException(message);
        }
        if (((state |= 1L) & 0x1FL) == (mask & 0x1FL)) {
            state |= 0x10000000L;
        }
    }

    public static final void checkContextualized(long state, long mask, String message) {
        if ((state & mask & 2L) > 0L || (mask & 2L) == 0L || state > 2L) {
            throw new IllegalStateException(message);
        }
        if (((state |= 2L) & 0x1FL) == (mask & 0x1FL)) {
            state |= 0x10000000L;
        }
    }

    public static final void checkParameterized(long state, long mask, String message) {
        if ((state & mask & 4L) > 0L || (mask & 4L) == 0L || state > 4L) {
            throw new IllegalStateException(message);
        }
        if (((state |= 4L) & 0x1FL) == (mask & 0x1FL)) {
            state |= 0x10000000L;
        }
    }

    public static final void checkConfigured(long state, long mask, String message) {
        if ((state & mask & 8L) > 0L || (mask & 8L) == 0L || state > 8L) {
            throw new IllegalStateException(message);
        }
        if (((state |= 8L) & 0x1FL) == (mask & 0x1FL)) {
            state |= 0x10000000L;
        }
    }

    public static final void checkInitialized(long state, long mask, String message) {
        if ((state & mask & 0x12L) > 0L || (mask & 0x12L) == 0L || state > 18L) {
            throw new IllegalStateException(message);
        }
        if (((state |= 0x12L) & 0x1FL) == (mask & 0x1FL)) {
            state |= 0x10000000L;
        }
    }

    public static final void checkStarted(long state, long mask, String message) {
        if ((state & mask & 0x14L) > 0L || (mask & 0x14L) == 0L || state > 20L) {
            throw new IllegalStateException(message);
        }
        if (((state |= 0x14L) & 0x1FL) == (mask & 0x1FL)) {
            state |= 0x10000000L;
        }
    }

    public static final void checkSuspended(long state, long mask, String message) {
        ComponentUtil.checkActive(state, mask, message);
        if ((state & mask & 0x1000000L) > 0L || (mask & 0x1000000L) == 0L) {
            throw new IllegalStateException(message);
        }
        state |= 0x1000000L;
    }

    public static final void checkResumed(long state, long mask, String message) {
        ComponentUtil.checkActive(state, mask, message);
        if ((state & mask & 0x1000000L) == 0L || (mask & 0x1000000L) == 0L) {
            throw new IllegalStateException(message);
        }
        state &= 0xFFFFFFFFFEFFFFFFL;
    }

    public static final void checkStopped(long state, long mask, String message) {
        if ((state & mask & 0x18L) > 0L || (mask & 0x18L) == 0L || (state & mask) > 24L) {
            throw new IllegalStateException(message);
        }
        state &= 0xFFFFFFFFEFFFFFFFL;
        state |= 0x18L;
    }

    public static final void checkDisposed(long state, long mask, String message) {
        if ((state & mask & 0x20L) > 0L || (mask & 0x20L) == 0L) {
            throw new IllegalStateException(message);
        }
        state &= 0xFFFFFFFFEFFFFFFFL;
        state |= 0x20L;
    }

    public static final void checkActive(long state, long mask, String message) {
        if ((0x10000000L & state) > 0L) {
            return;
        }
        throw new IllegalStateException(message);
    }

    private ComponentUtil() {
    }
}

