/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.format;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Stack;
import org.apache.log.ContextStack;
import org.apache.log.Formatter;
import org.apache.log.LogEntry;
import org.apache.log.LogKit;
import org.apache.log.Priority;

public class PatternFormatter
implements Formatter {
    protected static final int TYPE_TEXT = 1;
    protected static final int TYPE_CATEGORY = 2;
    protected static final int TYPE_CONTEXT = 3;
    protected static final int TYPE_MESSAGE = 4;
    protected static final int TYPE_TIME = 5;
    protected static final int TYPE_THROWABLE = 6;
    protected static final int TYPE_PRIORITY = 7;
    protected static final String TYPE_CATEGORY_STR = "category";
    protected static final String TYPE_CONTEXT_STR = "context";
    protected static final String TYPE_MESSAGE_STR = "message";
    protected static final String TYPE_TIME_STR = "time";
    protected static final String TYPE_THROWABLE_STR = "throwable";
    protected static final String TYPE_PRIORITY_STR = "priority";
    protected static final String SPACE_16 = "                ";
    protected static final String SPACE_8 = "        ";
    protected static final String SPACE_4 = "    ";
    protected static final String SPACE_2 = "  ";
    protected static final String SPACE_1 = " ";
    protected PatternRun[] m_formatSpecification;

    protected int addPatternRun(Stack stack, char[] pattern, int index) {
        int total;
        PatternRun run = new PatternRun();
        int start = index++;
        if ('+' == pattern[index]) {
            ++index;
        } else if ('-' == pattern[index]) {
            run.m_rightJustify = true;
            ++index;
        }
        if (Character.isDigit(pattern[index])) {
            total = 0;
            while (Character.isDigit(pattern[index])) {
                total = total * 10 + (pattern[index] - 48);
                ++index;
            }
            run.m_minSize = total;
        }
        if (index < pattern.length && '.' == pattern[index] && Character.isDigit(pattern[++index])) {
            total = 0;
            while (Character.isDigit(pattern[index])) {
                total = total * 10 + (pattern[index] - 48);
                ++index;
            }
            run.m_maxSize = total;
        }
        if (index >= pattern.length || '{' != pattern[index]) {
            throw new IllegalArgumentException("Badly formed pattern at character " + index);
        }
        int typeStart = index;
        while (index < pattern.length && pattern[index] != ':' && pattern[index] != '}') {
            ++index;
        }
        int typeEnd = index - 1;
        String type = new String(pattern, typeStart + 1, typeEnd - typeStart);
        run.m_type = this.getTypeIdFor(type);
        if (index < pattern.length && pattern[index] == ':') {
            ++index;
            while (index < pattern.length && pattern[index] != '}') {
                ++index;
            }
            int length = index - typeEnd - 2;
            if (length != 0) {
                run.m_format = new String(pattern, typeEnd + 2, length);
            }
        }
        if (index >= pattern.length || '}' != pattern[index]) {
            throw new IllegalArgumentException("Unterminated type in pattern at character " + index);
        }
        stack.push(run);
        return ++index - start;
    }

    protected int addTextRun(Stack stack, char[] pattern, int index) {
        PatternRun run = new PatternRun();
        int start = index;
        boolean escapeMode = false;
        if ('%' == pattern[index]) {
            ++index;
        }
        StringBuffer sb = new StringBuffer();
        while (index < pattern.length && pattern[index] != '%') {
            if (escapeMode) {
                if ('n' == pattern[index]) {
                    sb.append('\n');
                } else if ('t' == pattern[index]) {
                    sb.append('\t');
                } else {
                    sb.append(pattern[index]);
                }
                escapeMode = false;
            } else if ('\\' == pattern[index]) {
                escapeMode = true;
            } else {
                sb.append(pattern[index]);
            }
            ++index;
        }
        run.m_data = sb.toString();
        run.m_type = 1;
        stack.push(run);
        return index - start;
    }

    protected void append(StringBuffer sb, int minSize, int maxSize, boolean rightJustify, String output) {
        int size = output.length();
        if (size < minSize) {
            if (rightJustify) {
                this.appendWhiteSpace(sb, minSize - size);
                sb.append(output);
            } else {
                sb.append(output);
                this.appendWhiteSpace(sb, minSize - size);
            }
        } else if (maxSize > 0 && maxSize < size) {
            sb.append(output.substring(0, maxSize));
        } else {
            sb.append(output);
        }
    }

    protected void appendWhiteSpace(StringBuffer sb, int length) {
        while (length >= 16) {
            sb.append(SPACE_16);
            length -= 16;
        }
        if (length >= 8) {
            sb.append(SPACE_8);
            length -= 8;
        }
        if (length >= 4) {
            sb.append(SPACE_4);
            length -= 4;
        }
        if (length >= 2) {
            sb.append(SPACE_2);
            length -= 2;
        }
        if (length >= 1) {
            sb.append(SPACE_1);
            --length;
        }
    }

    public String format(LogEntry entry) {
        StringBuffer sb = new StringBuffer();
        String str = null;
        int i = 0;
        while (i < this.m_formatSpecification.length) {
            block10: {
                PatternRun run = this.m_formatSpecification[i];
                switch (run.m_type) {
                    case 1: {
                        sb.append(run.m_data);
                        break block10;
                    }
                    case 5: {
                        str = this.getTime(entry.getTime(), run.m_format);
                        break;
                    }
                    case 6: {
                        str = this.getStackTrace(entry.getThrowable(), run.m_format);
                        break;
                    }
                    case 4: {
                        str = this.getMessage(entry.getMessage(), run.m_format);
                        break;
                    }
                    case 3: {
                        str = this.getContext(entry.getContextStack(), run.m_format);
                        break;
                    }
                    case 2: {
                        str = this.getCategory(entry.getCategory().getName(), run.m_format);
                        break;
                    }
                    case 7: {
                        str = this.getPriority(entry.getPriority(), run.m_format);
                        break;
                    }
                    default: {
                        LogKit.log("Unknown Pattern specification." + run.m_type);
                        break block10;
                    }
                }
                this.append(sb, run.m_minSize, run.m_maxSize, run.m_rightJustify, str);
            }
            ++i;
        }
        return sb.toString();
    }

    protected String getCategory(String category, String format) {
        return category;
    }

    protected String getPriority(Priority.Enum priority, String format) {
        return priority.getName();
    }

    protected String getContext(ContextStack stack, String format) {
        int start;
        StringBuffer sb = new StringBuffer();
        int size = stack.getSize();
        int sizeSpecification = Integer.MAX_VALUE;
        if (format != null) {
            try {
                sizeSpecification = Integer.parseInt(format);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        int end = size - 1;
        int i = start = Math.max(end - sizeSpecification + 1, 0);
        while (i < end) {
            sb.append(stack.get(i));
            sb.append('.');
            ++i;
        }
        sb.append(stack.get(end));
        return sb.toString();
    }

    protected String getMessage(String message, String format) {
        return message;
    }

    protected String getStackTrace(Throwable throwable, String format) {
        if (throwable == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    protected String getTime(long time, String format) {
        return Long.toString(time);
    }

    protected int getTypeIdFor(String type) {
        if (type.equalsIgnoreCase(TYPE_CATEGORY_STR)) {
            return 2;
        }
        if (type.equalsIgnoreCase(TYPE_CONTEXT_STR)) {
            return 3;
        }
        if (type.equalsIgnoreCase(TYPE_MESSAGE_STR)) {
            return 4;
        }
        if (type.equalsIgnoreCase(TYPE_PRIORITY_STR)) {
            return 7;
        }
        if (type.equalsIgnoreCase(TYPE_TIME_STR)) {
            return 5;
        }
        if (type.equalsIgnoreCase(TYPE_THROWABLE_STR)) {
            return 6;
        }
        throw new IllegalArgumentException("Unknown Type in pattern - " + type);
    }

    protected void parse(String patternString) {
        Stack stack = new Stack();
        int size = patternString.length();
        char[] pattern = new char[size];
        int index = 0;
        patternString.getChars(0, size, pattern, 0);
        while (index < size) {
            if (pattern[index] == '%' && (index == size - 1 || pattern[index + 1] != '%')) {
                index += this.addPatternRun(stack, pattern, index);
                continue;
            }
            index += this.addTextRun(stack, pattern, index);
        }
        int elementCount = stack.size();
        this.m_formatSpecification = new PatternRun[elementCount];
        int i = 0;
        while (i < elementCount) {
            this.m_formatSpecification[i] = (PatternRun)stack.elementAt(i);
            ++i;
        }
    }

    public void setFormat(String format) {
        this.parse(format);
    }

    protected static class PatternRun {
        String m_data;
        boolean m_rightJustify;
        int m_minSize;
        int m_maxSize;
        int m_type;
        String m_format;

        PatternRun() {
        }
    }
}

