/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util;

public class CircularBuffer {
    private Object[] buffer;
    private int bufferSize;
    private int contentSize;
    private int head;
    private int tail;

    public boolean isEmpty() {
        return this.contentSize == 0;
    }

    public int getContentSize() {
        return this.contentSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void append(Object o) {
        if (this.contentSize >= this.bufferSize) {
            int j = 0;
            int i = this.tail;
            Object[] tmp = new Object[this.bufferSize * 2];
            while (this.contentSize > 0) {
                ++i;
                --this.contentSize;
                tmp[++j] = this.buffer[i %= this.bufferSize];
            }
            this.buffer = tmp;
            this.tail = 0;
            this.head = j;
            this.contentSize = j;
            this.bufferSize *= 2;
        }
        this.buffer[this.head] = o;
        ++this.head;
        this.head %= this.bufferSize;
        ++this.contentSize;
    }

    public Object get() {
        if (this.contentSize <= 0) {
            return null;
        }
        Object o = this.buffer[this.tail];
        ++this.tail;
        this.tail %= this.bufferSize;
        --this.contentSize;
        return o;
    }

    public CircularBuffer(int size) {
        this.buffer = new Object[size];
        this.bufferSize = size;
        this.contentSize = 0;
        this.head = 0;
        this.tail = 0;
    }

    public CircularBuffer() {
        this(32);
    }
}

