/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Circuit {
    private Hashtable map = new Hashtable();

    public void addNode(String name) {
        if (this.map.get(name) == null) {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            this.map.put(name, circuit.new Node(name));
        }
    }

    public void removeNode(String name) {
        String tmp = null;
        Enumeration e = this.map.keys();
        while (e.hasMoreElements()) {
            tmp = (String)e.nextElement();
            if (tmp.equals(name)) continue;
            try {
                this.unlink(tmp, name);
            }
            catch (CircuitException ignore) {
                // empty catch block
            }
            try {
                this.unlink(name, tmp);
            }
            catch (CircuitException ignore) {
                // empty catch block
            }
        }
        this.map.remove(name);
    }

    public void link(String parent, String child) throws CircuitException {
        Node tempNode = null;
        Node pnode = (Node)this.map.get(parent);
        Node cnode = (Node)this.map.get(child);
        if (pnode == null) {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            throw circuit.new CircuitException("Unknown node " + parent);
        }
        if (cnode == null) {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            throw circuit.new CircuitException("Unknown node " + child);
        }
        if (pnode.isChildOf(cnode)) {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            throw circuit.new CircuitException("Loop! Node " + parent + " is already child of node " + child);
        }
        Enumeration e = this.map.elements();
        while (e.hasMoreElements()) {
            tempNode = (Node)e.nextElement();
            if (!tempNode.isChildOf(cnode)) continue;
            tempNode.parents.addAll(pnode.parents);
        }
    }

    public void unlink(String parent, String child) throws CircuitException {
        Node cnode = (Node)this.map.get(child);
        Node pnode = (Node)this.map.get(parent);
        if (cnode.parents.contains(pnode)) {
            Node tempNode = null;
            Enumeration e = this.map.elements();
            while (e.hasMoreElements()) {
                tempNode = (Node)e.nextElement();
                if (!tempNode.parents.contains(cnode)) continue;
                tempNode.parents.removeAll(pnode.parents);
            }
        } else {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            throw circuit.new CircuitException("Node " + parent + " is not parent of node " + child);
        }
    }

    public Vector getAncestors() {
        Vector<String> ancestors = new Vector<String>();
        String name = null;
        Node tempNode = null;
        Enumeration e = this.map.keys();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            tempNode = (Node)this.map.get(name);
            if (tempNode.parents.size() != 1) continue;
            ancestors.addElement(name);
        }
        return ancestors;
    }

    public String getAncestor() {
        String name = null;
        Node tempNode = null;
        Enumeration e = this.map.keys();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            tempNode = (Node)this.map.get(name);
            if (tempNode.parents.size() != 1) continue;
            return name;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String name = null;
        Node tempNode = null;
        Enumeration e = this.map.keys();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            tempNode = (Node)this.map.get(name);
            buffer.append(name + "(" + (tempNode.parents.size() - 1) + ") ");
        }
        return buffer.toString();
    }

    protected final class Node {
        protected Vector parents = new Vector(5);
        protected String name;

        protected boolean isChildOf(Node parent) {
            return this.parents.contains(parent);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            Enumeration e = this.parents.elements();
            buffer.append(this.name + "[");
            while (e.hasMoreElements()) {
                buffer.append(((Node)e.nextElement()).name + " ");
            }
            buffer.append("]");
            return buffer.toString();
        }

        protected Node(String name) {
            this.parents.addElement(this);
            this.name = name;
        }
    }

    public final class CircuitException
    extends RuntimeException {
        public CircuitException() {
        }

        public CircuitException(String msg) {
            super(msg);
        }
    }
}

