/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.camelot;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.avalon.camelot.Deployer;
import org.apache.avalon.camelot.DeploymentException;
import org.apache.avalon.util.io.ExtensionFileFilter;

public final class CamelotUtil {
    public static void deployFromDirectory(Deployer deployer, File directory, String extention) throws DeploymentException {
        CamelotUtil.deployFromDirectory(deployer, directory, new String[]{extention});
    }

    public static void deployFromDirectory(Deployer deployer, File directory, String[] extentions) throws DeploymentException {
        ExtensionFileFilter filter = new ExtensionFileFilter(extentions);
        File[] files = directory.listFiles(filter);
        CamelotUtil.deployFiles(deployer, files);
    }

    public static void deployFiles(Deployer deployer, File[] files) throws DeploymentException {
        int i = 0;
        while (i < files.length) {
            String filename = files[i].getName();
            int index = filename.lastIndexOf(46);
            if (-1 == index) {
                index = filename.length();
            }
            String name = filename.substring(0, index);
            try {
                deployer.deploy(name, files[i].toURL());
            }
            catch (MalformedURLException mue) {
                throw new DeploymentException("Malformed URL for " + files[i], mue);
            }
            ++i;
        }
    }

    private CamelotUtil() {
    }
}

