/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.camelot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.avalon.ComponentManager;
import org.apache.avalon.ComponentNotAccessibleException;
import org.apache.avalon.ComponentNotFoundException;
import org.apache.avalon.Composer;
import org.apache.avalon.Configuration;
import org.apache.avalon.ConfigurationException;
import org.apache.avalon.DefaultConfigurationBuilder;
import org.apache.avalon.Loggable;
import org.apache.avalon.camelot.AbstractDeployer;
import org.apache.avalon.camelot.Container;
import org.apache.avalon.camelot.ContainerException;
import org.apache.avalon.camelot.DefaultLocator;
import org.apache.avalon.camelot.DeploymentException;
import org.apache.avalon.camelot.Entry;
import org.apache.avalon.camelot.LocatorRegistry;
import org.apache.avalon.camelot.RegistryException;
import org.apache.log.Logger;
import org.xml.sax.SAXException;

public abstract class AbstractZipDeployer
extends AbstractDeployer
implements Composer,
Loggable {
    protected final boolean m_deployToContainer;
    protected DefaultConfigurationBuilder m_builder;
    protected LocatorRegistry m_locatorRegistry;
    protected Container m_container;

    public void compose(ComponentManager componentManager) throws ComponentNotFoundException, ComponentNotAccessibleException {
        if (!this.m_deployToContainer) {
            this.m_locatorRegistry = (LocatorRegistry)componentManager.lookup("org.apache.avalon.camelot.LocatorRegistry");
        } else {
            this.m_container = (Container)componentManager.lookup("org.apache.avalon.camelot.Container");
        }
    }

    public void setLogger(Logger logger) {
        this.m_logger = logger;
    }

    protected void deployFromFile(String location, File file) throws DeploymentException {
        this.m_logger.info("Deploying " + this.m_type + " file (" + file + ") as " + location);
        ZipFile zipFile = this.getZipFileFor(file);
        URL url = null;
        try {
            try {
                url = file.toURL();
            }
            catch (MalformedURLException mue) {
                throw new DeploymentException("Unable to form url", mue);
            }
            this.loadResources(zipFile, location, url);
        }
        finally {
            Object var6_8 = null;
            try {
                zipFile.close();
            }
            catch (IOException ioe) {}
        }
    }

    protected ZipFile getZipFileFor(URL url) throws DeploymentException {
        File file = this.getFileFor(url);
        return this.getZipFileFor(file);
    }

    protected ZipFile getZipFileFor(File file) throws DeploymentException {
        try {
            return new ZipFile(file);
        }
        catch (IOException ioe) {
            throw new DeploymentException("Error opening " + file + " due to " + ioe.getMessage(), ioe);
        }
    }

    protected Configuration loadConfiguration(ZipFile zipFile, String filename) throws DeploymentException {
        this.m_logger.debug("loading configuration " + filename);
        return this.buildConfiguration(this.loadResourceStream(zipFile, filename));
    }

    protected Configuration buildConfiguration(InputStream input) throws DeploymentException {
        try {
            return this.m_builder.build(input);
        }
        catch (SAXException se) {
            throw new DeploymentException("Malformed configuration data", se);
        }
        catch (ConfigurationException ce) {
            throw new DeploymentException("Error building configuration", ce);
        }
        catch (IOException ioe) {
            throw new DeploymentException("Error reading configuration", ioe);
        }
    }

    protected Properties loadProperties(ZipFile zipFile, String filename) throws DeploymentException {
        this.m_logger.debug("loading properties " + filename);
        Properties properties = new Properties();
        try {
            properties.load(this.loadResourceStream(zipFile, filename));
        }
        catch (IOException ioe) {
            throw new DeploymentException("Error reading " + filename + " from " + zipFile.getName(), ioe);
        }
        return properties;
    }

    protected InputStream loadResourceStream(ZipFile zipFile, String filename) throws DeploymentException {
        ZipEntry entry = zipFile.getEntry(filename);
        if (entry == null) {
            throw new DeploymentException("Unable to locate " + filename + " in " + zipFile.getName());
        }
        try {
            return zipFile.getInputStream(entry);
        }
        catch (IOException ioe) {
            throw new DeploymentException("Error reading " + filename + " from " + zipFile.getName(), ioe);
        }
    }

    protected void addEntry(String name, Entry entry) throws DeploymentException {
        try {
            this.m_container.add(name, entry);
        }
        catch (ContainerException ce) {
            throw new DeploymentException("Error adding component to container", ce);
        }
        this.m_logger.debug("Adding " + this.m_type + "Entry " + name + " as " + entry);
    }

    protected void addLocator(String name, String classname, URL url) throws DeploymentException {
        DefaultLocator locator = new DefaultLocator(classname, url);
        try {
            this.m_locatorRegistry.register(name, locator);
        }
        catch (RegistryException re) {
            throw new DeploymentException("Error registering " + name + " due to " + re, re);
        }
        this.m_logger.debug("Registered " + this.m_type + " " + name + " as " + classname);
    }

    protected abstract void loadResources(ZipFile var1, String var2, URL var3) throws DeploymentException;

    public AbstractZipDeployer(boolean deployToContainer) {
        this.m_deployToContainer = deployToContainer;
        this.m_builder = new DefaultConfigurationBuilder();
    }
}

