/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.camelot;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.apache.avalon.Component;
import org.apache.avalon.camelot.Deployer;
import org.apache.avalon.camelot.DeploymentException;
import org.apache.avalon.util.io.FileUtil;
import org.apache.log.Logger;

public abstract class AbstractDeployer
implements Deployer {
    protected final HashMap m_deployments = new HashMap();
    protected boolean m_autoUndeploy;
    protected Logger m_logger;
    protected String m_type;

    public void deploy(String location, URL url) throws DeploymentException {
        this.checkDeployment(location, url);
        File file = this.getFileFor(url);
        this.deployFromFile(location, file);
    }

    protected void checkDeployment(String location, URL url) throws DeploymentException {
        if (this.m_deployments.get(location) != null) {
            throw new DeploymentException(this.m_type + " already exists at " + location);
        }
        if (!this.isValidLocation(location)) {
            throw new DeploymentException("Invalid location (" + location + ") for " + this.m_type);
        }
    }

    public void undeploy(String location) throws DeploymentException {
        Component component = (Component)this.m_deployments.get(location);
        if (component == null) {
            throw new DeploymentException(this.m_type + " does not exist at " + location);
        }
        boolean canUndeploy = this.canUndeploy(component);
        if (!canUndeploy) {
            if (!this.m_autoUndeploy) {
                throw new DeploymentException(this.m_type + " not ready to undeploy at " + location);
            }
            this.shutdownDeployment(component);
        }
        this.m_deployments.remove(location);
    }

    protected File getCacheLocationFor(URL url) throws DeploymentException {
        throw new DeploymentException("Unable to deploy non-local resources");
    }

    protected File getFileFor(URL url) throws DeploymentException {
        File file = null;
        if (url.getProtocol().equals("file")) {
            file = new File(url.getFile());
        } else {
            file = this.getCacheLocationFor(url);
            try {
                FileUtil.copyURLToFile(url, file);
            }
            catch (IOException ioe) {
                throw new DeploymentException("Failed attempting to copy from  " + url + " to local file cache " + file, ioe);
            }
        }
        file = file.getAbsoluteFile();
        if (!file.exists()) {
            throw new DeploymentException("Could not find application archive at " + file);
        }
        if (file.isDirectory()) {
            throw new DeploymentException("Could not find application archive at " + file + " as it is a directory.");
        }
        return file;
    }

    protected boolean isValidLocation(String location) {
        return true;
    }

    protected boolean canUndeploy(Component component) throws DeploymentException {
        return true;
    }

    protected void shutdownDeployment(Component component) throws DeploymentException {
    }

    protected abstract void deployFromFile(String var1, File var2) throws DeploymentException;
}

