/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.AbstractConfiguration;
import org.apache.avalon.Configuration;
import org.apache.avalon.ConfigurationException;

public class DefaultConfiguration
extends AbstractConfiguration {
    protected static final Iterator EMPTY_ITERATOR = ((AbstractList)new ArrayList(1)).iterator();
    protected final String m_name;
    protected final String m_location;
    protected HashMap m_attributes;
    protected ArrayList m_children;
    protected String m_value;

    public String getName() {
        return this.m_name;
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getValue() throws ConfigurationException {
        if (this.m_value != null) {
            return this.m_value;
        }
        throw new ConfigurationException("No value is associated with the configuration element \"" + this.getName() + "\"");
    }

    public String getAttribute(String name) throws ConfigurationException {
        String value;
        String string = value = this.m_attributes != null ? (String)this.m_attributes.get(name) : null;
        if (value != null) {
            return value;
        }
        throw new ConfigurationException("No attribute named \"" + name + "\" is " + "associated with the configuration element \"" + this.getName() + "\"");
    }

    public Configuration getChild(String name) throws ConfigurationException {
        if (this.m_children == null) {
            throw new ConfigurationException("No child name with name " + name);
        }
        int size = this.m_children.size();
        int i = 0;
        while (i < size) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            if (name.equals(configuration.getName())) {
                return configuration;
            }
            ++i;
        }
        throw new ConfigurationException("No child name with name " + name);
    }

    public Iterator getChildren(String name) {
        ArrayList<Configuration> children = new ArrayList<Configuration>();
        if (this.m_children == null) {
            return EMPTY_ITERATOR;
        }
        int size = this.m_children.size();
        int i = 0;
        while (i < size) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            if (name.equals(configuration.getName())) {
                children.add(configuration);
            }
            ++i;
        }
        return ((AbstractList)children).iterator();
    }

    public void appendValueData(String value) {
        this.m_value = this.m_value == null ? value : this.m_value + value;
    }

    public String addAttribute(String name, String value) {
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap();
        }
        return this.m_attributes.put(name, value);
    }

    public void addChild(Configuration configuration) {
        if (this.m_children == null) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(configuration);
    }

    public DefaultConfiguration(String name, String location) {
        this.m_name = name;
        this.m_location = location;
    }
}

