/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;

public class Mapper
extends DataType {
    protected Project p;
    protected MapperType type = null;
    protected String classname = null;
    protected Path classpath = null;
    protected String from = null;
    protected String to = null;

    public Mapper(Project project) {
        this.p = project;
    }

    public void setType(MapperType mapperType) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.type = mapperType;
    }

    public void setClassname(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.classname = string;
    }

    public void setClasspath(Path path) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.classpath == null) {
            this.classpath = new Path(this.p);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createClasspath().setRefid(reference);
    }

    public void setFrom(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.from = string;
    }

    public void setTo(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.to = string;
    }

    public void setRefid(Reference reference) throws BuildException {
        if (this.type != null || this.from != null || this.to != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    public FileNameMapper getImplementation() throws BuildException {
        if (this.isReference()) {
            return this.getRef().getImplementation();
        }
        if (this.type == null && this.classname == null) {
            throw new BuildException("one of the attributes type or classname is required");
        }
        if (this.type != null && this.classname != null) {
            throw new BuildException("must not specify both type and classname attribute");
        }
        try {
            try {
                Object object;
                if (this.type != null) {
                    this.classname = this.type.getImplementation();
                }
                Class<?> clazz = null;
                if (this.classpath == null) {
                    clazz = Class.forName(this.classname);
                } else {
                    object = new AntClassLoader(this.p, this.classpath);
                    clazz = ((ClassLoader)object).loadClass(this.classname);
                    AntClassLoader.initializeClass(clazz);
                }
                object = (FileNameMapper)clazz.newInstance();
                object.setFrom(this.from);
                object.setTo(this.to);
                Object object2 = object;
                Object var5_6 = null;
                if (this.type != null) {
                    this.classname = null;
                }
                return object2;
            }
            catch (BuildException buildException) {
                throw buildException;
            }
            catch (Throwable throwable) {
                throw new BuildException(throwable);
            }
        }
        catch (Throwable throwable) {
            block12: {
                Object var5_7 = null;
                if (this.type == null) break block12;
                this.classname = null;
            }
            throw throwable;
        }
    }

    protected Mapper getRef() {
        Object object;
        if (!this.checked) {
            object = new Stack<Mapper>();
            ((Stack)object).push(this);
            this.dieOnCircularReference((Stack)object, this.p);
        }
        if (!((object = this.ref.getReferencedObject(this.p)) instanceof Mapper)) {
            String string = this.ref.getRefId() + " doesn't denote a mapper";
            throw new BuildException(string);
        }
        return (Mapper)object;
    }

    public static class MapperType
    extends EnumeratedAttribute {
        private Properties implementations = new Properties();

        public MapperType() {
            ((Hashtable)this.implementations).put("identity", "org.apache.tools.ant.util.IdentityMapper");
            ((Hashtable)this.implementations).put("flatten", "org.apache.tools.ant.util.FlatFileNameMapper");
            ((Hashtable)this.implementations).put("glob", "org.apache.tools.ant.util.GlobPatternMapper");
            ((Hashtable)this.implementations).put("merge", "org.apache.tools.ant.util.MergingMapper");
            ((Hashtable)this.implementations).put("regexp", "org.apache.tools.ant.util.RegexpPatternMapper");
        }

        public String[] getValues() {
            return new String[]{"identity", "flatten", "glob", "merge", "regexp"};
        }

        public String getImplementation() {
            return this.implementations.getProperty(this.getValue());
        }
    }
}

