/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import org.apache.avalon.excalibur.pool.DefaultObjectFactory;
import org.apache.avalon.excalibur.pool.DefaultPool;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.PoolController;
import org.apache.avalon.excalibur.pool.Resizable;

public class SoftResourceLimitingPool
extends DefaultPool
implements Resizable {
    public void initialize() throws Exception {
        this.grow(this.m_min);
        this.m_initialized = true;
    }

    public void grow(int amount) {
        block7: {
            try {
                try {
                    this.m_mutex.lock();
                    this.internalGrow(amount);
                }
                catch (InterruptedException ie) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Interrupted while waiting on lock", (Throwable)ie);
                    }
                    Object var3_3 = null;
                    this.m_mutex.unlock();
                    break block7;
                }
                catch (Exception e) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Could not grow the pool properly, an exception was caught", (Throwable)e);
                    }
                    Object var3_4 = null;
                    this.m_mutex.unlock();
                }
                Object var3_2 = null;
                this.m_mutex.unlock();
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.m_mutex.unlock();
                throw throwable;
            }
        }
    }

    public void shrink(int amount) {
        block7: {
            try {
                try {
                    this.m_mutex.lock();
                    this.internalShrink(amount);
                }
                catch (InterruptedException ie) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Interrupted while waiting on lock", (Throwable)ie);
                    }
                    Object var3_3 = null;
                    this.m_mutex.unlock();
                    break block7;
                }
                catch (Exception e) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Could not shrink the pool properly, an exception was caught", (Throwable)e);
                    }
                    Object var3_4 = null;
                    this.m_mutex.unlock();
                }
                Object var3_2 = null;
                this.m_mutex.unlock();
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.m_mutex.unlock();
                throw throwable;
            }
        }
    }

    public SoftResourceLimitingPool(ObjectFactory factory) throws Exception {
        this(factory, 4);
    }

    public SoftResourceLimitingPool(ObjectFactory factory, int min) throws Exception {
        this(factory, null, min, min * 2);
    }

    public SoftResourceLimitingPool(ObjectFactory factory, int min, int max) throws Exception {
        this(factory, null, min, max);
    }

    public SoftResourceLimitingPool(ObjectFactory factory, PoolController controller, int min, int max) throws Exception {
        super(factory, controller, min, max);
    }

    public SoftResourceLimitingPool(Class clazz, int initial, int maximum) throws NoSuchMethodException, Exception {
        this(new DefaultObjectFactory(clazz), initial, maximum);
    }

    public SoftResourceLimitingPool(Class clazz, int initial) throws NoSuchMethodException, Exception {
        this(clazz, initial, initial);
    }
}

