/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.avalon.excalibur.logger.LogTargetFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log.LogTarget;
import org.apache.log.output.db.ColumnInfo;
import org.apache.log.output.db.ColumnType;
import org.apache.log.output.db.DefaultJDBCTarget;
import org.apache.log.output.db.NormalizedJDBCTarget;

public class JDBCTargetFactory
implements LogTargetFactory {
    /*
     * WARNING - void declaration
     */
    public LogTarget createTarget(Configuration configuration) throws ConfigurationException {
        DefaultJDBCTarget logTarget;
        void dataSource;
        String dataSourceName = configuration.getChild("datasource", true).getValue();
        boolean normalized = configuration.getChild("normalized", true).getValueAsBoolean(false);
        Configuration tableConfiguration = configuration.getChild("table");
        String table = tableConfiguration.getAttribute("name");
        Configuration[] conf = tableConfiguration.getChildren();
        ColumnInfo[] columns = new ColumnInfo[conf.length];
        int i2 = 0;
        while (i2 < conf.length) {
            String name = conf[i2].getValue();
            int type = ColumnType.getTypeIdFor((String)conf[i2].getName());
            String aux = conf[i2].getAttribute("aux", null);
            columns[i2] = new ColumnInfo(name, type, aux);
            ++i2;
        }
        try {
            InitialContext ctx = new InitialContext();
            DataSource i2 = (DataSource)ctx.lookup(dataSourceName);
        }
        catch (NamingException ne) {
            throw new ConfigurationException("Cannot lookup data source", (Throwable)ne);
        }
        if (normalized) {
            NormalizedJDBCTarget ne = new NormalizedJDBCTarget((DataSource)dataSource, table, columns);
        } else {
            logTarget = new DefaultJDBCTarget((DataSource)dataSource, table, columns);
        }
        return logTarget;
    }
}

