/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.camelot;

import java.net.URL;
import org.apache.avalon.ComponentManager;
import org.apache.avalon.ComponentManagerException;
import org.apache.avalon.Composer;
import org.apache.avalon.camelot.AbstractDeployer;
import org.apache.avalon.camelot.Container;
import org.apache.avalon.camelot.ContainerException;
import org.apache.avalon.camelot.DefaultLocator;
import org.apache.avalon.camelot.DeploymentException;
import org.apache.avalon.camelot.Entry;
import org.apache.avalon.camelot.Info;
import org.apache.avalon.camelot.LocatorRegistry;
import org.apache.avalon.camelot.Registry;
import org.apache.avalon.camelot.RegistryException;

public abstract class AbstractCamelotDeployer
extends AbstractDeployer
implements Composer {
    protected boolean m_deployToContainer;
    protected boolean m_deployToLocatorRegistry;
    protected boolean m_deployToInfoRegistry;
    protected LocatorRegistry m_locatorRegistry;
    protected Container m_container;
    protected Registry m_infoRegistry;

    public void compose(ComponentManager componentManager) throws ComponentManagerException {
        if (this.m_deployToLocatorRegistry) {
            this.m_locatorRegistry = (LocatorRegistry)componentManager.lookup("org.apache.avalon.camelot.LocatorRegistry");
        }
        if (this.m_deployToInfoRegistry) {
            this.m_infoRegistry = (Registry)componentManager.lookup("org.apache.avalon.camelot.Registry");
        }
        if (this.m_deployToContainer) {
            this.m_container = (Container)componentManager.lookup("org.apache.avalon.camelot.Container");
        }
    }

    protected void addEntry(String name, Entry entry) throws DeploymentException {
        try {
            this.m_container.add(name, entry);
        }
        catch (ContainerException ce) {
            throw new DeploymentException("Error adding component to container", ce);
        }
        this.getLogger().debug("Adding " + this.m_type + "Entry " + name + " as " + entry);
    }

    protected void addLocator(String name, String classname, URL url) throws DeploymentException {
        DefaultLocator locator = new DefaultLocator(classname, url);
        try {
            this.m_locatorRegistry.register(name, locator);
        }
        catch (RegistryException re) {
            throw new DeploymentException("Error registering " + name + " due to " + re, re);
        }
        this.getLogger().debug("Registered " + this.m_type + " " + name + " as " + classname);
    }

    protected void addInfo(String name, Info info) throws DeploymentException {
        try {
            this.m_infoRegistry.register(name, info);
        }
        catch (RegistryException re) {
            throw new DeploymentException("Error registering " + name + " due to " + re, re);
        }
        this.getLogger().debug("Registered Info " + this.m_type + " " + name);
    }
}

