/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.extension;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.avalon.excalibur.extension.Extension;
import org.apache.avalon.excalibur.extension.OptionalPackage;
import org.apache.avalon.excalibur.extension.PackageRepository;

public class DefaultPackageRepository
implements PackageRepository {
    private static final boolean DEBUG = false;
    private final HashMap m_packages = new HashMap();
    private File[] m_path;
    private boolean m_needToScan;

    public DefaultPackageRepository(File[] path) {
        this.setPath(path);
    }

    public synchronized OptionalPackage[] getOptionalPackages(Extension extension) {
        if (this.m_needToScan) {
            this.scanPath();
        }
        ArrayList<OptionalPackage> results = new ArrayList<OptionalPackage>();
        ArrayList candidates = (ArrayList)this.m_packages.get(extension.getExtensionName());
        if (null != candidates) {
            int size = candidates.size();
            int i = 0;
            while (i < size) {
                OptionalPackage optionalPackage = (OptionalPackage)candidates.get(i);
                Extension[] extensions = optionalPackage.getAvailableExtensions();
                int j = 0;
                while (j < extensions.length) {
                    if (extensions[j].isCompatibleWith(extension)) {
                        results.add(optionalPackage);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return results.toArray(new OptionalPackage[0]);
    }

    protected synchronized void setPath(File[] path) {
        if (null == path) {
            throw new NullPointerException("path property is null");
        }
        int i = 0;
        while (i < path.length) {
            File directory = path[i];
            if (!directory.exists() || !directory.isDirectory()) {
                throw new IllegalArgumentException("path element " + directory + " must exist and must be a directory");
            }
            ++i;
        }
        this.m_path = path;
        this.m_needToScan = true;
    }

    protected final synchronized void scanPath() {
        this.clearCache();
        int i = 0;
        while (i < this.m_path.length) {
            this.scanDirectory(this.m_path[i]);
            ++i;
        }
    }

    private synchronized void scanDirectory(File directory) {
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String name = file.getName();
            if (!name.endsWith(".jar")) {
                this.debug("Skipping " + file + " as it does not end with '.jar'");
            } else if (!file.isFile()) {
                this.debug("Skipping " + file + " as it is not a file.");
            } else if (!file.canRead()) {
                this.debug("Skipping " + file + " as it is not readable.");
            } else {
                try {
                    OptionalPackage optionalPackage = this.getOptionalPackage(file);
                    this.cacheOptionalPackage(optionalPackage);
                }
                catch (IOException ioe) {
                    this.debug("Skipping " + file + " as it could not be loaded due to " + ioe);
                }
            }
            ++i;
        }
    }

    protected final synchronized void clearCache() {
        this.m_packages.clear();
        this.m_needToScan = true;
    }

    protected final synchronized void cacheOptionalPackage(OptionalPackage optionalPackage) {
        this.m_needToScan = false;
        Extension extension = optionalPackage.getAvailableExtensions()[0];
        ArrayList<OptionalPackage> candidates = (ArrayList<OptionalPackage>)this.m_packages.get(extension.getExtensionName());
        if (null == candidates) {
            candidates = new ArrayList<OptionalPackage>();
            this.m_packages.put(extension.getExtensionName(), candidates);
        }
        candidates.add(optionalPackage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OptionalPackage getOptionalPackage(File archive) throws IOException {
        OptionalPackage optionalPackage;
        JarFile jarFile;
        block4: {
            OptionalPackage optionalPackage2;
            block3: {
                File file = archive.getCanonicalFile();
                jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                try {
                    if (null == manifest) {
                        optionalPackage2 = null;
                        Object var9_7 = null;
                        break block3;
                    }
                    Extension[] available = Extension.getAvailable(manifest);
                    Extension[] required = Extension.getRequired(manifest);
                    optionalPackage = new OptionalPackage(file, available, required);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    jarFile.close();
                    throw throwable;
                }
            }
            jarFile.close();
            return optionalPackage2;
        }
        Object var9_8 = null;
        jarFile.close();
        return optionalPackage;
    }

    protected void debug(String message) {
    }
}

